/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.log.CtpLogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SystemUtil {
    private static final Log logger = CtpLogFactory.getLog(SystemUtil.class);

    public static String getServiceIp() {
        String ip = null;
        try {
            ip = SystemUtil.getSelfIP();
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6ip\u5931\u8d25", (Throwable)e);
        }
        return ip;
    }

    public static int getServicePort() {
        int port = -1;
        try {
            port = Integer.parseInt(SystemUtil.getSelfPort());
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u7aef\u53e3\u5931\u8d25", (Throwable)e);
        }
        return port;
    }

    private static boolean isWindowsOS() {
        boolean isWindowsOS = false;
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().indexOf("windows") > -1) {
            isWindowsOS = true;
        }
        return isWindowsOS;
    }

    private static String getSelfIP() throws Exception {
        if (SystemUtil.isWindowsOS()) {
            return SystemUtil.getWindowsLocalIp();
        }
        return SystemUtil.getLinuxLocalIp();
    }

    private static String getWindowsLocalIp() throws Exception {
        String ip = InetAddress.getLocalHost().getHostAddress();
        return ip;
    }

    private static String getLinuxLocalIp() throws Exception {
        String ip = "";
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface intf = en.nextElement();
            String name = intf.getName();
            if (name.contains("docker") || name.contains("lo")) continue;
            Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
            while (enumIpAddr.hasMoreElements()) {
                String ipaddress;
                InetAddress inetAddress = enumIpAddr.nextElement();
                if (inetAddress.isLoopbackAddress() || (ipaddress = inetAddress.getHostAddress().toString()).contains("::") || ipaddress.contains("0:0:") || ipaddress.contains("fe80")) continue;
                ip = ipaddress;
            }
        }
        return ip;
    }

    private static String getSelfPort() throws Exception {
        String port = "";
        DocumentBuilderFactory builder = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = builder.newDocumentBuilder();
        String filePath = SystemUtil.getServerXmlPath();
        File file = new File(filePath);
        FileInputStream is = new FileInputStream(file);
        Document doc = db.parse(is);
        Element root = doc.getDocumentElement();
        NodeList list = root.getElementsByTagName("Connector");
        for (int i = 0; i < list.getLength(); ++i) {
            NamedNodeMap map;
            Node protocolNode;
            Node node = list.item(i);
            if (!node.hasAttributes() || (protocolNode = (map = node.getAttributes()).getNamedItem("protocol")) == null || !protocolNode.getNodeValue().equals("HTTP/1.1")) continue;
            port = map.getNamedItem("port").getNodeValue();
            break;
        }
        return port;
    }

    private static String getServerXmlPath() throws Exception {
        String filePath = "";
        String classPath = Thread.currentThread().getContextClassLoader().getResource("").getPath();
        classPath = classPath.replaceAll("%20", " ");
        int fromIndex = classPath.indexOf("/WEB-INF") - 1;
        int endIndex = classPath.lastIndexOf("/", fromIndex) - 1;
        endIndex = classPath.lastIndexOf("/", endIndex) + 1;
        filePath = classPath.substring(0, endIndex);
        filePath = filePath + "conf/server.xml";
        return filePath;
    }
}

