/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.constants.SystemProperties;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.customize.manager.CustomizeManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceBundleUtil;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.common.po.customize.CtpCustomize;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TimeZoneUtil {
    private static int TRANSTIMEZONE_BY_CUSTSET = 0;
    private static int TRANSTIMEZONE_BY_PRIVSET = 1;
    private static final Log LOG = LogFactory.getLog(TimeZoneUtil.class);

    public static boolean isEnable() {
        boolean isEnable = false;
        try {
            if (AppContext.hasPlugin("timezone") && "1".equals(SystemProperties.getInstance().getProperty("timezone.set.enable"))) {
                isEnable = true;
            }
        }
        catch (Throwable e) {
            LOG.debug((Object)e.getLocalizedMessage(), e);
        }
        return isEnable;
    }

    public static TimeZone getCustomerTimeZone() {
        int transTimezoneType = TRANSTIMEZONE_BY_CUSTSET;
        if (transTimezoneType == TRANSTIMEZONE_BY_PRIVSET) {
            return TimeZoneUtil.getTimeZoneByPrivSet();
        }
        return TimeZoneUtil.getTimeZoneByCustSet();
    }

    public static TimeZone getTimeZoneByCustSet() {
        if (null != AppContext.getCurrentUser() && TimeZoneUtil.isEnable()) {
            return AppContext.getCurrentUser().getTimeZone();
        }
        return TimeZone.getDefault();
    }

    public static TimeZone getTimeZoneByPrivSet() {
        if (null != AppContext.getCurrentUser() && TimeZoneUtil.isEnable()) {
            if (AppContext.getCurrentUser().isAdmin()) {
                return AppContext.getCurrentUser().getTimeZone();
            }
            CustomizeManager customizeManager = (CustomizeManager)AppContext.getBean("customizeManager");
            CtpCustomize timeZone = customizeManager.getCustomizeInfo(AppContext.getCurrentUser().getId(), "timezone");
            if (null != timeZone) {
                try {
                    Long setTimeZone = Long.valueOf(timeZone.getCvalue());
                    EnumManager enumManagerNew = (EnumManager)AppContext.getBean("enumManagerNew");
                    CtpEnumItem enumItem = enumManagerNew.getCtpEnumItem(setTimeZone);
                    String timezoneOffset = enumItem.getEnumvalue();
                    return TimeZone.getTimeZone(TimeZoneUtil.getTimeZoneId(timezoneOffset));
                }
                catch (BusinessException businessException) {}
            } else {
                return AppContext.getCurrentUser().getTimeZone();
            }
        }
        return TimeZone.getDefault();
    }

    public static TimeZone getCustomerTimeZone(Long memberId) {
        if (null != memberId && TimeZoneUtil.isEnable()) {
            CustomizeManager customizeManager = (CustomizeManager)AppContext.getBean("customizeManager");
            CtpCustomize timeZone = customizeManager.getCustomizeInfo(memberId, "timezone");
            if (null != timeZone) {
                try {
                    Long setTimeZone = Long.valueOf(timeZone.getCvalue());
                    EnumManager enumManagerNew = (EnumManager)AppContext.getBean("enumManagerNew");
                    CtpEnumItem enumItem = enumManagerNew.getCtpEnumItem(setTimeZone);
                    String timezoneOffset = enumItem.getEnumvalue();
                    return TimeZone.getTimeZone(TimeZoneUtil.getTimeZoneId(timezoneOffset));
                }
                catch (BusinessException businessException) {}
            } else {
                return TimeZone.getDefault();
            }
        }
        return TimeZone.getDefault();
    }

    public static int getDiffTimeZoneRawOffset(TimeZone timeZone) {
        return TimeZone.getDefault().getRawOffset() - TimeZone.getTimeZone(timeZone.getID()).getRawOffset();
    }

    public static void transCalendarToCustomer(Calendar calendar, TimeZone timeZone) {
        long time = calendar.getTime().getTime();
        int diffTime = TimeZoneUtil.getDiffTimeZoneRawOffset(timeZone);
        long customerTime = time - (long)diffTime;
        calendar.setTime(new Date(customerTime));
    }

    public static void transCalendarToCustomer(Calendar calendar) {
        TimeZoneUtil.transCalendarToCustomer(calendar, TimeZoneUtil.getCustomerTimeZone());
    }

    public static String getTimeZoneId(String timezoneOffsetStr) {
        int timezoneOffset;
        String gmtHours;
        String[] gmtHoursArr;
        String h;
        int len = timezoneOffsetStr.length();
        if (len <= 1) {
            return "GMT";
        }
        String t = timezoneOffsetStr.substring(0, len - 1);
        if (!t.endsWith("0") && !t.endsWith("5")) {
            if (len <= 2) {
                return "GMT";
            }
            t = timezoneOffsetStr.substring(0, len - 2);
        }
        if (Integer.valueOf(h = (gmtHoursArr = (gmtHours = String.valueOf((timezoneOffset = Integer.valueOf(t).intValue()) / 60)).split("\\."))[0]) >= 0) {
            h = "+" + h;
        }
        String m = "00";
        if (gmtHoursArr.length > 1) {
            m = String.valueOf(Double.valueOf("0." + gmtHoursArr[1]) * 60.0);
        }
        return "GMT" + h + ":" + m;
    }

    public static String timeZoneSettingAlert() {
        String resourceName = "com.seeyon.v3x.common.resources.i18n.SeeyonCommonResources";
        String message = "";
        if (TimeZoneUtil.isEnable() && !AppContext.getCurrentUser().isAdmin()) {
            CustomizeManager customizeManager = (CustomizeManager)AppContext.getBean("customizeManager");
            CtpCustomize timeZone = customizeManager.getCustomizeInfo(AppContext.getCurrentUser().getId(), "timezone");
            if (null == timeZone) {
                message = ResourceBundleUtil.getString(resourceName, "timezone.alert.noset", new Object[0]);
            } else {
                try {
                    Long setTimeZone = Long.valueOf(timeZone.getCvalue());
                    EnumManager enumManagerNew = (EnumManager)AppContext.getBean("enumManagerNew");
                    CtpEnumItem enumItem = enumManagerNew.getCtpEnumItem(setTimeZone);
                    String timezoneOffset = enumItem.getEnumvalue();
                    int setRawOffset = TimeZone.getTimeZone(TimeZoneUtil.getTimeZoneId(timezoneOffset)).getRawOffset();
                    int currentRawOffset = AppContext.getCurrentUser().getTimeZone().getRawOffset();
                    if (Integer.valueOf(setRawOffset).compareTo(currentRawOffset) != 0) {
                        message = ResourceBundleUtil.getString(resourceName, "timezone.alert.noequal", new Object[0]);
                    }
                }
                catch (BusinessException businessException) {
                    // empty catch block
                }
            }
        }
        StringBuilder alertMsg = new StringBuilder();
        alertMsg.append(message);
        return alertMsg.toString();
    }
}

