/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class UniqueList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = -80089300015253835L;
    private Set<E> set = new HashSet();

    public UniqueList() {
    }

    public UniqueList(Collection<? extends E> c) {
        super(c);
        for (E e : c) {
            this.set.add(e);
        }
    }

    public UniqueList(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public boolean add(E o) {
        if (!this.set.contains(o)) {
            this.set.add(o);
            return super.add(o);
        }
        return false;
    }

    @Override
    public void add(int index, E element) {
        if (!this.set.contains(element)) {
            this.set.add(element);
            super.add(index, element);
        } else {
            int orginalIndex = super.indexOf(element);
            super.remove(orginalIndex);
            super.add(index, element);
            this.set.add(element);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c == null) {
            return false;
        }
        for (E e : c) {
            this.add(e);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        for (E e : c) {
            this.add(e);
        }
        return true;
    }

    @Override
    public boolean contains(Object elem) {
        return this.set.contains(elem);
    }

    @Override
    public E remove(int index) {
        Object e = super.remove(index);
        this.set.remove(e);
        return e;
    }

    @Override
    public boolean remove(Object o) {
        this.set.remove(o);
        return super.remove(o);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        for (int i = fromIndex; i < toIndex; ++i) {
            this.remove(i);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.set.clear();
    }
}

