/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.cache;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.timer.TimerHolder;
import com.seeyon.ctp.util.LimitedMap;
import com.seeyon.ctp.util.cache.ClickCache;
import com.seeyon.ctp.util.cache.ClickDetail;
import com.seeyon.ctp.util.cache.UpdateClickManager;
import com.seeyon.ctp.util.cache.UpdateClickTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;

public class DataCache<T> {
    private static final Log log = CtpLogFactory.getLog(DataCache.class);
    private UpdateClickManager updateClickManager;
    private LimitedMap<Long, T, Long> dataMap;
    private Map<Long, ClickCache> clickCacheMap;
    private int cacheTimes;
    private int updateMins;

    public void click(long dataId, ClickDetail detail) {
        ClickCache cc = this.clickCacheMap.get(dataId);
        if (cc == null) {
            return;
        }
        cc.click(detail);
        if (cc.getClickNum() >= this.cacheTimes) {
            this.updateClick(cc);
            cc.setClickNum(0);
        }
    }

    public void check4Update() {
        Collection<ClickCache> ccs = this.clickCacheMap.values();
        for (ClickCache cc : ccs) {
            if (cc.getClickNum() == 0 || cc.getClickNum() < this.cacheTimes && System.currentTimeMillis() - cc.getClickTime().getTime() < (long)(this.updateMins * 60 * 1000)) continue;
            this.updateClick(cc);
        }
    }

    public void updateAll() {
        Collection<ClickCache> ccs = this.clickCacheMap.values();
        for (ClickCache cc : ccs) {
            if (cc.getClickNum() == 0) continue;
            this.updateClick(cc);
        }
    }

    private void updateClick(ClickCache cc) {
        if (cc == null || cc.getClickNum() == 0) {
            return;
        }
        this.updateClickManager.updateClick(cc.getDataId(), cc.getClickTotal(), cc.getClickDetails());
    }

    public DataCache(UpdateClickManager updateClickManager, int dataCount, LimitedMap<Long, T, Long> dataMap, int cacheTimes, int updateMins) {
        this.updateClickManager = updateClickManager;
        this.dataMap = dataMap != null ? dataMap : new LimitedMap(dataCount, new ArrayList(), new ArrayList(), new ArrayList(), null);
        this.clickCacheMap = new HashMap<Long, ClickCache>();
        this.cacheTimes = cacheTimes;
        this.updateMins = updateMins;
        this.startTimer();
    }

    public DataCache(UpdateClickManager updateClickManager) {
        this(updateClickManager, 10, null, 30, 30);
    }

    private void startTimer() {
        TimerHolder.newTimer((Runnable)new UpdateClickTask(this), 1000L, 60000L * (long)this.updateMins);
    }

    public final T get(long dataId) {
        return this.dataMap.get(dataId);
    }

    public final Long save(long dataId, T data, long timeMillis, int clickTotal) {
        Long ret = this.dataMap.add(dataId, data, timeMillis);
        if (ret != null) {
            ClickCache cc = new ClickCache(dataId, clickTotal);
            this.clickCacheMap.put(dataId, cc);
            if (!ret.equals(dataId)) {
                ClickCache cc2 = this.clickCacheMap.get(ret);
                this.updateClick(cc2);
                this.clickCacheMap.remove(ret);
            }
        }
        return ret;
    }

    public void remove(long dataId) {
        this.dataMap.remove(dataId);
        this.clickCacheMap.remove(dataId);
    }

    public final int getClickTotal(long dataId) {
        ClickCache cc = this.clickCacheMap.get(dataId);
        if (cc == null) {
            return 0;
        }
        return cc.getClickTotal();
    }

    public final ClickCache getClickCache(long dataId) {
        return this.clickCacheMap.get(dataId);
    }

    public int getCacheTimes() {
        return this.cacheTimes;
    }

    public void setCacheTimes(int cacheTimes) {
        this.cacheTimes = cacheTimes;
    }

    public Map<Long, ClickCache> getClickCacheMap() {
        return this.clickCacheMap;
    }

    public void setClickCacheMap(Map<Long, ClickCache> clickCacheMap) {
        this.clickCacheMap = clickCacheMap;
    }

    public LimitedMap<Long, T, Long> getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(LimitedMap<Long, T, Long> dataMap) {
        this.dataMap = dataMap;
    }

    public UpdateClickManager getUpdateClickManager() {
        return this.updateClickManager;
    }

    public void setUpdateClickManager(UpdateClickManager updateClickManager) {
        this.updateClickManager = updateClickManager;
    }

    public int getUpdateMins() {
        return this.updateMins;
    }

    public void setUpdateMins(int updateMins) {
        this.updateMins = updateMins;
    }
}

