/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.CTPDateFormatDeserializer;
import com.seeyon.ctp.util.json.KeyEnumDeserializer;
import java.lang.reflect.Type;
import java.util.Date;
import org.apache.commons.logging.Log;

public class JSONUtil {
    private static final Log logger = CtpLogFactory.getLog(JSONUtil.class);
    private static ParserConfig globalInstance = ParserConfig.getGlobalInstance();
    private static KeyEnumDeserializer deserializer = new KeyEnumDeserializer();

    private static void registerKeyEnumDeserializer(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            globalInstance.putDeserializer(clazz, (ObjectDeserializer)deserializer);
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)("\u6ce8\u518c\u679a\u4e3eDeserializer\u5931\u8d25\uff1a" + className + " " + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private static Object handleString(String value) {
        return Strings.escapeUnsupportAscii(value);
    }

    public static String toJSONString(Object object) {
        String obj = null;
        obj = object != null ? JSON.toJSONString((Object)object, (SerializeFilter)new ValueFilter(){

            public Object process(Object object, String name, Object value) {
                if (value instanceof Number) {
                    return String.valueOf(value);
                }
                if (value instanceof Date) {
                    return Datetimes.formatDatetime((Date)value);
                }
                if (value instanceof String) {
                    return JSONUtil.handleString((String)value);
                }
                return value;
            }
        }, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}) : "{}";
        if (!Strings.isEmpty(obj)) {
            obj = obj.replaceAll("</script>", "<\\\\/script>");
        }
        return obj;
    }

    public static String toJSONString4Ajax(Object object) {
        String obj = null;
        obj = object != null ? (object instanceof String ? JSON.toJSONString((Object)object, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}) : (object instanceof Integer ? String.valueOf(object) : (object instanceof Number ? "\"" + String.valueOf(object) + "\"" : JSON.toJSONString((Object)object, (SerializeFilter)new ValueFilter(){

            public Object process(Object object, String name, Object value) {
                if (value instanceof Number && !(value instanceof Integer)) {
                    if (value instanceof Double || value instanceof Float) {
                        return String.valueOf(value).replaceAll("\\.?0*$", "");
                    }
                    return String.valueOf(value);
                }
                if (value instanceof Date) {
                    return Datetimes.formatDatetimeWithoutSecond((Date)value);
                }
                if (value instanceof String) {
                    return JSONUtil.handleString((String)value);
                }
                return value;
            }
        }, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.BrowserCompatible, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteMapNullValue})))) : "null";
        return obj;
    }

    public static Object parseJSONString(String jsonString) {
        return JSONUtil.parseJSONString(jsonString, null);
    }

    public static <T> T parseJSONString(String jsonString, Class<T> cls) {
        Object result = null;
        if (jsonString != null && !"".equals(jsonString.trim()) && !"undefined".equals(jsonString)) {
            result = JSON.parseObject((String)jsonString, cls);
        }
        return (T)result;
    }

    public static <T> T parseJSONString(String jsonString, Type type) {
        Object result = null;
        if (jsonString != null && !"".equals(jsonString.trim()) && !"undefined".equals(jsonString)) {
            result = JSON.parseObject((String)jsonString, (Type)type, (Feature[])new Feature[0]);
        }
        return (T)result;
    }

    static {
        JSONUtil.registerKeyEnumDeserializer("com.seeyon.ctp.common.content.mainbody.MainbodyType");
        JSONUtil.registerKeyEnumDeserializer("com.seeyon.ctp.common.ModuleType");
        globalInstance.putDeserializer(Date.class, (ObjectDeserializer)new CTPDateFormatDeserializer());
    }
}

