/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.json.mapper;

import com.seeyon.ctp.util.json.helper.HelperRepository;
import com.seeyon.ctp.util.json.mapper.MapperException;
import com.seeyon.ctp.util.json.mapper.helper.SimpleMapperHelper;
import com.seeyon.ctp.util.json.mapper.helper.impl.ArrayMapper;
import com.seeyon.ctp.util.json.mapper.helper.impl.BigDecimalMapper;
import com.seeyon.ctp.util.json.mapper.helper.impl.BigIntegerMapper;
import com.seeyon.ctp.util.json.mapper.helper.impl.BooleanMapper;
import com.seeyon.ctp.util.json.mapper.helper.impl.ByteMapper;
import com.seeyon.ctp.util.json.mapper.helper.impl.CharacterMapper;
import com.seeyon.ctp.util.json.mapper.helper.impl.CollectionMapper;
import com.seeyon.ctp.util.json.mapper.helper.impl.DateMapper;
import com.seeyon.ctp.util.json.mapper.helper.impl.DoubleMapper;
import com.seeyon.ctp.util.json.mapper.helper.impl.EnumMapper;
import com.seeyon.ctp.util.json.mapper.helper.impl.FloatMapper;
import com.seeyon.ctp.util.json.mapper.helper.impl.IntegerMapper;
import com.seeyon.ctp.util.json.mapper.helper.impl.LongMapper;
import com.seeyon.ctp.util.json.mapper.helper.impl.MapMapper;
import com.seeyon.ctp.util.json.mapper.helper.impl.ObjectMapper;
import com.seeyon.ctp.util.json.mapper.helper.impl.PONoExtraMapper;
import com.seeyon.ctp.util.json.mapper.helper.impl.ShortMapper;
import com.seeyon.ctp.util.json.mapper.helper.impl.StringMapper;
import com.seeyon.ctp.util.json.mapper.helper.impl.TimestampMapper;
import com.seeyon.ctp.util.json.model.JSONNull;
import com.seeyon.ctp.util.json.model.JSONValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedList;

public class JSONMapper {
    private static HelperRepository repo = new HelperRepository();
    private static final ThreadLocal<Class<?>> ParameterizedTypeLocal = new ThreadLocal();

    public static void setParameterizedTypeLocal(Class<?> clz) {
        ParameterizedTypeLocal.set(clz);
    }

    public static Class<?> getParameterizedTypeLocal() {
        return ParameterizedTypeLocal.get();
    }

    public static Object toJava(JSONValue aValue, Class clazz) throws MapperException {
        Class aPojoClass = clazz;
        if (aValue == null) {
            String lMsg = "Mapper does not support null values.";
            throw new MapperException("Mapper does not support null values.");
        }
        if (aValue.isNull()) {
            return null;
        }
        if (aPojoClass.isArray()) {
            ArrayMapper arrayMapper = new ArrayMapper();
            return arrayMapper.toJava(aValue, aPojoClass);
        }
        if (Boolean.TYPE.equals(aPojoClass)) {
            aPojoClass = Boolean.class;
        } else if (Byte.TYPE.equals(aPojoClass)) {
            aPojoClass = Byte.class;
        } else if (Short.TYPE.equals(aPojoClass)) {
            aPojoClass = Short.class;
        } else if (Integer.TYPE.equals(aPojoClass)) {
            aPojoClass = Integer.class;
        } else if (Long.TYPE.equals(aPojoClass)) {
            aPojoClass = Long.class;
        } else if (Float.TYPE.equals(aPojoClass)) {
            aPojoClass = Float.class;
        } else if (Double.TYPE.equals(aPojoClass)) {
            aPojoClass = Double.class;
        } else if (Character.TYPE.equals(aPojoClass)) {
            aPojoClass = Character.class;
        }
        SimpleMapperHelper lHelperSimple = (SimpleMapperHelper)repo.findHelper(aPojoClass);
        if (lHelperSimple == null) {
            String lMsg = "Could not find a mapper helper for class: " + aPojoClass.getName();
            throw new MapperException(lMsg);
        }
        return lHelperSimple.toJava(aValue, aPojoClass);
    }

    public static Object toJava(JSONValue aValue) throws MapperException {
        Object result = aValue.isArray() ? JSONMapper.toJava(aValue, LinkedList.class) : (aValue.isBoolean() ? JSONMapper.toJava(aValue, Boolean.class) : (aValue.isDecimal() ? JSONMapper.toJava(aValue, BigDecimal.class) : (aValue.isInteger() ? JSONMapper.toJava(aValue, BigInteger.class) : (aValue.isString() ? JSONMapper.toJava(aValue, String.class) : JSONMapper.toJava(aValue, Object.class)))));
        return result;
    }

    public static JSONValue toJSON(Object aPojo) throws MapperException {
        if (aPojo == null) {
            return JSONNull.NULL;
        }
        Class<?> lObjectClass = aPojo.getClass();
        if (lObjectClass.isArray()) {
            ArrayMapper arrayMapper = new ArrayMapper();
            return arrayMapper.toJSON(aPojo);
        }
        SimpleMapperHelper lHelperSimple = (SimpleMapperHelper)repo.findHelper(aPojo.getClass());
        if (lHelperSimple == null) {
            String lMsg = "Could not find a mapper helper for class: " + aPojo.getClass().getName();
            throw new MapperException(lMsg);
        }
        return lHelperSimple.toJSON(aPojo);
    }

    public static JSONValue toJSONNOExtraAttr(Object aPojo) throws MapperException {
        PONoExtraMapper lHelperSimple = new PONoExtraMapper();
        return lHelperSimple.toJSON(aPojo);
    }

    static {
        repo.addHelper(new ObjectMapper());
        repo.addHelper(new StringMapper());
        repo.addHelper(new BooleanMapper());
        repo.addHelper(new ByteMapper());
        repo.addHelper(new ShortMapper());
        repo.addHelper(new IntegerMapper());
        repo.addHelper(new LongMapper());
        repo.addHelper(new FloatMapper());
        repo.addHelper(new DoubleMapper());
        repo.addHelper(new BigIntegerMapper());
        repo.addHelper(new BigDecimalMapper());
        repo.addHelper(new CharacterMapper());
        repo.addHelper(new TimestampMapper());
        repo.addHelper(new DateMapper());
        repo.addHelper(new CollectionMapper());
        repo.addHelper(new MapMapper());
        repo.addHelper(new EnumMapper());
    }
}

