/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.json.mapper.helper.impl;

import com.seeyon.ctp.util.json.mapper.MapperException;
import com.seeyon.ctp.util.json.mapper.helper.SimpleMapperHelper;
import com.seeyon.ctp.util.json.model.JSONBoolean;
import com.seeyon.ctp.util.json.model.JSONString;
import com.seeyon.ctp.util.json.model.JSONValue;

public class BooleanMapper
implements SimpleMapperHelper {
    @Override
    public Class getHelpedClass() {
        return Boolean.class;
    }

    @Override
    public Object toJava(JSONValue aValue, Class aRequestedClass) throws MapperException {
        if (aValue.isString()) {
            return Boolean.valueOf(((JSONString)aValue).getValue());
        }
        if (aValue.isBoolean()) {
            return new Boolean(((JSONBoolean)aValue).getValue());
        }
        throw new MapperException("BooleanMapper cannot map: " + aValue.getClass().getName());
    }

    @Override
    public JSONValue toJSON(Object aPojo) throws MapperException {
        if (!Boolean.class.isAssignableFrom(aPojo.getClass())) {
            throw new MapperException("BooleanMapper cannot map: " + aPojo.getClass().getName());
        }
        return new JSONBoolean((Boolean)aPojo);
    }
}

