/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.json.mapper.helper.impl;

import com.seeyon.ctp.util.ClassUtil;
import com.seeyon.ctp.util.json.mapper.MapperException;
import com.seeyon.ctp.util.json.mapper.helper.SimpleMapperHelper;
import com.seeyon.ctp.util.json.model.JSONInteger;
import com.seeyon.ctp.util.json.model.JSONString;
import com.seeyon.ctp.util.json.model.JSONValue;

public class LongMapper
implements SimpleMapperHelper {
    @Override
    public Class getHelpedClass() {
        return Long.class;
    }

    @Override
    public Object toJava(JSONValue aValue, Class aRequestedClass) throws MapperException {
        if (aValue.isString()) {
            try {
                return ClassUtil.toLong(((JSONString)aValue).getValue());
            }
            catch (NumberFormatException e) {
                throw new MapperException("LongMapper cannot map value: " + ((JSONString)aValue).getValue());
            }
        }
        if (aValue.isInteger()) {
            return new Long(((JSONInteger)aValue).getValue().longValue());
        }
        throw new MapperException("LongMapper cannot map: " + aValue.getClass().getName());
    }

    @Override
    public JSONValue toJSON(Object aPojo) throws MapperException {
        if (!Long.class.isAssignableFrom(aPojo.getClass())) {
            throw new MapperException("LongMapper cannot map: " + aPojo.getClass().getName());
        }
        return new JSONString(aPojo.toString());
    }
}

