/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.ctp.util.json.mapper.helper.impl;

import com.seeyon.ctp.util.ClassUtil;
import com.seeyon.ctp.util.json.mapper.MapperException;
import com.seeyon.ctp.util.json.mapper.helper.SimpleMapperHelper;
import com.seeyon.ctp.util.json.model.JSONInteger;
import com.seeyon.ctp.util.json.model.JSONString;
import com.seeyon.ctp.util.json.model.JSONValue;
import java.math.BigInteger;

public class ShortMapper
implements SimpleMapperHelper {
    @Override
    public Class getHelpedClass() {
        return Short.class;
    }

    @Override
    public Object toJava(JSONValue aValue, Class aRequestedClass) throws MapperException {
        if (aValue.isString()) {
            try {
                return ClassUtil.CASE(((JSONString)aValue).getValue(), Short.class);
            }
            catch (NumberFormatException e) {
                throw new MapperException("ShortMapper cannot map value: " + ((JSONString)aValue).getValue());
            }
        }
        if (aValue.isInteger()) {
            return new Short((short)((JSONInteger)aValue).getValue().intValue());
        }
        throw new MapperException("ShortMapper cannot map: " + aValue.getClass().getName());
    }

    @Override
    public JSONValue toJSON(Object aPojo) throws MapperException {
        if (!Short.class.isAssignableFrom(aPojo.getClass())) {
            throw new MapperException("ShortMapper cannot map: " + aPojo.getClass().getName());
        }
        return new JSONInteger(new BigInteger(aPojo.toString()));
    }
}

