/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.statistics;

public class MethodInvokeInfo {
    private String methodPath;
    private int invokeNum = 0;
    private long totalTime = 0L;
    private long maxTime = 0L;
    private long peakDateTime;

    public MethodInvokeInfo(String method) {
        this.methodPath = method;
    }

    public String getMethodPath() {
        return this.methodPath;
    }

    public int getInvokeNum() {
        return this.invokeNum;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public synchronized void addOneInvoke(long invokeTime, long time) {
        this.totalTime += time;
        ++this.invokeNum;
        if (time > this.maxTime) {
            this.maxTime = time;
            this.peakDateTime = invokeTime;
        }
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public long getPeakDateTime() {
        return this.peakDateTime;
    }

    public long getAverageTime() {
        return this.totalTime / (long)this.invokeNum;
    }

    public boolean equals(Object o) {
        if (o instanceof MethodInvokeInfo) {
            return ((MethodInvokeInfo)o).getMethodPath().equals(this.methodPath);
        }
        return false;
    }

    public int hashCode() {
        return this.methodPath.hashCode();
    }
}

