/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.statistics;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PerformanceStatistics {
    private static Map<String, List<ExecuteDescription>> executionMap = new LinkedHashMap<String, List<ExecuteDescription>>();
    private static Map<String, Map<Integer, Integer>> executionStatisticsMap = new LinkedHashMap<String, Map<Integer, Integer>>();
    private static boolean running = false;
    private static final long MAX_STATISTICS_TIME_MILLIS = 60000L;
    private static long startTimeMillis;
    public static final int METHOD = 0;
    public static final int TRANSACTION = 1;
    public static final int SQL = 2;

    public static synchronized void clear() {
        executionMap.clear();
        executionStatisticsMap.clear();
    }

    public static synchronized void start() {
        running = true;
    }

    public static synchronized void stop() {
        running = false;
    }

    public static Map<String, List<ExecuteDescription>> getExecutionMap() {
        return executionMap;
    }

    public static Map<String, Map<Integer, Integer>> getExecutionStatisticsMap() {
        return executionStatisticsMap;
    }

    public static synchronized void addExecution(String threadName, int opType, Object message) {
        if (!running) {
            return;
        }
        if (executionMap.size() == 0) {
            startTimeMillis = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - startTimeMillis > 60000L) {
            running = false;
            return;
        }
        if (!executionMap.containsKey(threadName)) {
            executionMap.put(threadName, new ArrayList());
            executionStatisticsMap.put(threadName, new LinkedHashMap());
        }
        executionMap.get(threadName).add(new ExecuteDescription(opType, message.toString()));
        Map<Integer, Integer> statisticsMap = executionStatisticsMap.get(threadName);
        Integer count = statisticsMap.get(opType);
        if (count == null) {
            statisticsMap.put(opType, 1);
        } else {
            count = count + 1;
            statisticsMap.put(opType, count);
        }
    }

    public static class ExecuteDescription {
        private int opType;
        private String description;

        public ExecuteDescription(int opType, String description) {
            this.opType = opType;
            this.description = description;
        }

        public int getOpType() {
            return this.opType;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

