/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.v3x.common.ajax;

import com.seeyon.cdp.RequestTracker;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.web.util.WebUtil;
import com.seeyon.statistics.MethodInvokeStatistics;
import com.seeyon.v3x.common.ajax.AJAXResponse;
import com.seeyon.v3x.common.ajax.AJAXService;
import com.seeyon.v3x.common.ajax.impl.AJAXRequestImpl;
import com.seeyon.v3x.common.ajax.impl.AJAXResponseMobileWrapperImpl;
import com.seeyon.v3x.common.web.util.ResponseUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;

public class AJAXDataServlet
extends HttpServlet {
    private static final long serialVersionUID = 3573767581315962977L;
    private static final String CONTENT_TYPE_XML = "text/xml; charset=UTF-8";
    private static final String CONTENT_TYPE_HTML = "text/html; charset=UTF-8";
    private static final Log log = CtpLogFactory.getLog(AJAXDataServlet.class);
    private transient AJAXService ajaxService;
    private static final Set<String> WHITE_LIST = new HashSet<String>(Arrays.asList("ajaxColManager_colDelLock", "ajaxEdocSummaryManager_deleteUpdateObj", "ajaxEdocManager_ajaxCheckNodeHasExchangeType", "ajaxEdocSummaryManager_deleteUpdateRecieveObj"));

    public void init() throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ResponseUtil.addResponseHeader(request, response);
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        long startTime = System.currentTimeMillis();
        String serviceName = request.getParameter("S");
        String methodName = request.getParameter("M");
        String returnValueType = request.getParameter("RVT");
        try {
            if (this.ajaxService == null) {
                this.ajaxService = (AJAXService)AppContext.getBean("AJAXService");
            }
            if ("XML".equals(returnValueType)) {
                response.setContentType(CONTENT_TYPE_XML);
            } else {
                response.setContentType(CONTENT_TYPE_HTML);
            }
            WebUtil.setRequest(request);
            WebUtil.setResponse(response);
            AJAXRequestImpl ajaxRequest = new AJAXRequestImpl(request, response, serviceName, methodName);
            AJAXResponse ajaxResponse = this.ajaxService.processRequest(ajaxRequest);
            String callback = ajaxRequest.getServletRequest().getParameter("callback");
            if (callback != null) {
                AJAXResponseMobileWrapperImpl wrapper = new AJAXResponseMobileWrapperImpl(ajaxRequest, ajaxResponse);
                wrapper.complete(returnValueType);
            } else {
                ajaxResponse.complete(returnValueType);
            }
        }
        catch (Exception ex) {
            response.setContentType(CONTENT_TYPE_HTML);
            log.error((Object)"AJAX Service error.", (Throwable)ex);
            response.sendError(500, "AJAX Service error. Cause: " + ex.getMessage());
        }
        finally {
            RequestTracker.trackV3xAjax(request, serviceName, methodName, startTime);
            AppContext.clearThreadContext();
            MethodInvokeStatistics.removeThreadLocal();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void destroy() {
    }

    private boolean needCheckLogin(String serviceName, String methodName) {
        if (serviceName == null || methodName == null) {
            return false;
        }
        return !WHITE_LIST.contains(serviceName.trim() + "_" + methodName.trim());
    }
}

