/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.v3x.common.ajax.impl;

import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.Strings;
import com.seeyon.v3x.common.ajax.AJAXException;
import com.seeyon.v3x.common.ajax.AJAXParameter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class AJAXParameterImpl
implements AJAXParameter {
    protected static final Log log = CtpLogFactory.getLog(AJAXParameterImpl.class);
    private Class className;
    private Object value;

    public AJAXParameterImpl(String typeName, String paramValue, String[] paramArrayValue, boolean isNeedEncoder) throws AJAXException {
        if (Strings.isBlank(typeName)) {
            throw new AJAXException("Parameter's Type must be not NULL.");
        }
        if ("String".equalsIgnoreCase(typeName)) {
            this.className = String.class;
            if (isNeedEncoder) {
                try {
                    this.value = new String(paramValue.getBytes("8859_1"), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    log.warn((Object)"\u6587\u5b57\u8f6c\u7801\u5931\u8d25", (Throwable)e);
                }
            } else {
                this.value = paramValue;
            }
        } else if ("String[]".equalsIgnoreCase(typeName)) {
            this.className = String[].class;
            if (isNeedEncoder) {
                String[] _value = new String[paramArrayValue.length];
                for (int i = 0; i < paramArrayValue.length; ++i) {
                    try {
                        _value[i] = new String(paramArrayValue[i].getBytes("8859_1"), "UTF-8");
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        log.warn((Object)"\u6587\u5b57\u8f6c\u7801\u5931\u8d25", (Throwable)e);
                    }
                }
                this.value = _value;
            } else {
                this.value = paramArrayValue;
            }
        } else if ("long".equals(typeName)) {
            this.className = Long.TYPE;
            this.value = (long)new Long(paramValue);
        } else if ("long[]".equals(typeName)) {
            this.className = long[].class;
            long[] _value = new long[paramArrayValue.length];
            for (int i = 0; i < paramArrayValue.length; ++i) {
                _value[i] = new Long(paramArrayValue[i]);
            }
            this.value = _value;
        } else if ("Long".equals(typeName)) {
            this.className = Long.class;
            this.value = StringUtils.isNotBlank((CharSequence)paramValue) ? new Long(paramValue) : null;
        } else if ("Long[]".equals(typeName)) {
            this.className = Long[].class;
            Long[] _value = new Long[paramArrayValue.length];
            for (int i = 0; i < paramArrayValue.length; ++i) {
                _value[i] = new Long(paramArrayValue[i]);
            }
            this.value = _value;
        } else if ("int".equals(typeName)) {
            this.className = Integer.TYPE;
            this.value = (int)new Integer(paramValue);
        } else if ("int[]".equals(typeName)) {
            this.className = int[].class;
            int[] _value = new int[paramArrayValue.length];
            for (int i = 0; i < paramArrayValue.length; ++i) {
                _value[i] = new Integer(paramArrayValue[i]);
            }
            this.value = _value;
        } else if ("Integer".equals(typeName)) {
            this.className = Integer.class;
            this.value = StringUtils.isNotBlank((CharSequence)paramValue) ? new Integer(paramValue) : null;
        } else if ("Integer[]".equals(typeName)) {
            this.className = Integer[].class;
            Integer[] _value = new Integer[paramArrayValue.length];
            for (int i = 0; i < paramArrayValue.length; ++i) {
                _value[i] = new Integer(paramArrayValue[i]);
            }
            this.value = _value;
        } else if ("boolean".equals(typeName)) {
            this.className = Boolean.TYPE;
            this.value = (boolean)new Boolean(paramValue);
        } else if ("boolean[]".equals(typeName)) {
            this.className = boolean[].class;
            boolean[] _value = new boolean[paramArrayValue.length];
            for (int i = 0; i < paramArrayValue.length; ++i) {
                _value[i] = new Boolean(paramArrayValue[i]);
            }
            this.value = _value;
        } else if ("Boolean".equals(typeName)) {
            this.className = Boolean.class;
            this.value = StringUtils.isNotBlank((CharSequence)paramValue) ? new Boolean(paramValue) : null;
        } else if ("Boolean[]".equals(typeName)) {
            this.className = Boolean[].class;
            Boolean[] _value = new Boolean[paramArrayValue.length];
            for (int i = 0; i < paramArrayValue.length; ++i) {
                _value[i] = new Boolean(paramArrayValue[i]);
            }
            this.value = _value;
        } else if ("byte".equals(typeName)) {
            this.className = Byte.TYPE;
            this.value = (byte)new Byte(paramValue);
        } else if ("byte[]".equals(typeName)) {
            this.className = byte[].class;
            byte[] _value = new byte[paramArrayValue.length];
            for (int i = 0; i < paramArrayValue.length; ++i) {
                _value[i] = new Byte(paramArrayValue[i]);
            }
            this.value = _value;
        } else if ("Byte".equals(typeName)) {
            this.className = Byte.class;
            this.value = StringUtils.isNotBlank((CharSequence)paramValue) ? new Byte(paramValue) : null;
        } else if ("Byte[]".equals(typeName)) {
            this.className = Byte[].class;
            Byte[] _value = new Byte[paramArrayValue.length];
            for (int i = 0; i < paramArrayValue.length; ++i) {
                _value[i] = new Byte(paramArrayValue[i]);
            }
            this.value = _value;
        } else if ("short".equals(typeName)) {
            this.className = Short.TYPE;
            this.value = (short)new Short(paramValue);
        } else if ("short[]".equals(typeName)) {
            this.className = short[].class;
            short[] _value = new short[paramArrayValue.length];
            for (int i = 0; i < paramArrayValue.length; ++i) {
                _value[i] = new Short(paramArrayValue[i]);
            }
            this.value = _value;
        } else if ("Short".equals(typeName)) {
            this.className = Short.class;
            this.value = StringUtils.isNotBlank((CharSequence)paramValue) ? new Short(paramValue) : null;
        } else if ("Short[]".equals(typeName)) {
            this.className = Short[].class;
            Short[] _value = new Short[paramArrayValue.length];
            for (int i = 0; i < paramArrayValue.length; ++i) {
                _value[i] = new Short(paramArrayValue[i]);
            }
            this.value = _value;
        } else if ("double".equals(typeName)) {
            this.className = Double.TYPE;
            this.value = (double)new Double(paramValue);
        } else if ("double[]".equals(typeName)) {
            this.className = Byte[].class;
            double[] _value = new double[paramArrayValue.length];
            for (int i = 0; i < paramArrayValue.length; ++i) {
                _value[i] = new Double(paramArrayValue[i]);
            }
            this.value = _value;
        } else if ("Double".equals(typeName)) {
            this.className = Double.class;
            this.value = StringUtils.isNotBlank((CharSequence)paramValue) ? new Double(paramValue) : null;
        } else if ("Double[]".equals(typeName)) {
            this.className = Double[].class;
            Double[] _value = new Double[paramArrayValue.length];
            for (int i = 0; i < paramArrayValue.length; ++i) {
                _value[i] = new Double(paramArrayValue[i]);
            }
            this.value = _value;
        } else if ("float".equals(typeName)) {
            this.className = Float.TYPE;
            this.value = Float.valueOf(new Float(paramValue).floatValue());
        } else if ("float[]".equals(typeName)) {
            this.className = Double[].class;
            float[] _value = new float[paramArrayValue.length];
            for (int i = 0; i < paramArrayValue.length; ++i) {
                _value[i] = new Float(paramArrayValue[i]).floatValue();
            }
            this.value = _value;
        } else if ("Float".equals(typeName)) {
            this.className = Float.class;
            this.value = StringUtils.isNotBlank((CharSequence)paramValue) ? new Float(paramValue) : null;
        } else if ("Float[]".equals(typeName)) {
            this.className = Float[].class;
            Float[] _value = new Float[paramArrayValue.length];
            for (int i = 0; i < paramArrayValue.length; ++i) {
                _value[i] = new Float(paramArrayValue[i]);
            }
            this.value = _value;
        } else if ("char".equals(typeName)) {
            this.className = Character.TYPE;
            this.value = "".equals(paramValue) ? new Character('\u0000') : Character.valueOf(new Character(paramValue.charAt(0)).charValue());
        } else if ("char[]".equals(typeName)) {
            this.className = char[].class;
            char[] _value = new char[paramArrayValue.length];
            for (int i = 0; i < paramArrayValue.length; ++i) {
                _value[i] = "".equals(paramValue) ? new Character('\u0000').charValue() : new Character(paramArrayValue[i].charAt(0)).charValue();
            }
            this.value = _value;
        } else if ("Character".equals(typeName)) {
            this.className = Character.class;
            this.value = "".equals(paramValue) ? new Character('\u0000') : new Character(paramValue.charAt(0));
        } else if ("Character[]".equals(typeName)) {
            this.className = Character[].class;
            Character[] _value = new Character[paramArrayValue.length];
            for (int i = 0; i < paramArrayValue.length; ++i) {
                _value[i] = "".equals(paramValue) ? new Character('\u0000') : new Character(paramArrayValue[i].charAt(0));
            }
            this.value = _value;
        } else if ("DATE".equalsIgnoreCase(typeName)) {
            this.className = Date.class;
            this.value = AJAXParameterImpl.parseDate(paramValue);
        } else if ("DATE[]".equalsIgnoreCase(typeName)) {
            this.className = Date[].class;
            Date[] _value = new Date[paramArrayValue.length];
            for (int i = 0; i < paramArrayValue.length; ++i) {
                _value[i] = AJAXParameterImpl.parseDate(paramValue);
            }
            this.value = _value;
        } else {
            throw new AJAXException("Parameter type '" + typeName + "' is invalidity.");
        }
    }

    private static Date parseDate(String paramValue) {
        Date date = null;
        if (StringUtils.isNumeric((CharSequence)paramValue)) {
            try {
                long minute = Long.parseLong(paramValue);
                date = new Date(minute);
            }
            catch (Exception exception) {}
        } else if (StringUtils.isNotBlank((CharSequence)paramValue)) {
            try {
                date = Datetimes.parse(paramValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return date;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Class getClassName() {
        return this.className;
    }

    public String toString() {
        return this.value + "\t" + this.className;
    }
}

