/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.v3x.common.search.manager;

import com.seeyon.ctp.common.dao.BaseHibernateDao;
import com.seeyon.ctp.common.dao.paginate.Pagination;
import com.seeyon.v3x.common.search.manager.SearchManager;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projections;
import org.hibernate.type.Type;
import org.springframework.orm.hibernate3.HibernateCallback;

public class SearchManagerImpl
extends BaseHibernateDao
implements SearchManager {
    private static final Log log = LogFactory.getLog(SearchManagerImpl.class);

    @Override
    public List searchByCriteria(final DetachedCriteria detachedCriteria) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = detachedCriteria.getExecutableCriteria(session);
                List items = criteria.setFirstResult(Pagination.getFirstResult()).setMaxResults(Pagination.getMaxResults()).list();
                return items;
            }
        });
    }

    @Override
    public int getCountByCriteria(final DetachedCriteria detachedCriteria) {
        Number count = (Number)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria criteria = detachedCriteria.getExecutableCriteria(session);
                return criteria.setProjection(Projections.rowCount()).uniqueResult();
            }
        });
        return count.intValue();
    }

    public List searchEqual(String hql, String value) {
        List result = this.getHibernateTemplate().find(hql, (Object)value);
        return result;
    }

    public List searchLike(String hql, String value) {
        List result = this.getHibernateTemplate().find(hql, (Object)value);
        return result;
    }

    @Override
    public List searchByHql(final String hqlStr, final Map<String, Object> parameterMap) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                if (Pagination.isNeedCount().booleanValue()) {
                    int index = hqlStr.indexOf("from");
                    String countSql = hqlStr.substring(index);
                    countSql = "select COUNT(*) " + countSql;
                    Query query0 = session.createQuery(hqlStr);
                    SearchManagerImpl.this.setQueryValue(query0, parameterMap);
                    List listNum = query0.list();
                    int totalCount = 0;
                    try {
                        totalCount = listNum.size();
                    }
                    catch (HibernateException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    Pagination.setRowCount(totalCount);
                }
                Query query = session.createQuery(hqlStr);
                SearchManagerImpl.this.setQueryValue(query, parameterMap);
                query.setFirstResult(Pagination.getFirstResult());
                query.setMaxResults(Pagination.getMaxResults());
                List list = query.list();
                return list;
            }
        });
    }

    public Query setQueryValue(Query query, Map<String, Object> map) {
        if (map != null) {
            Set<Map.Entry<String, Object>> entries = map.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                if (entry.getKey().equals("parameterrNameList")) continue;
                if (entry.getValue() instanceof Collection) {
                    query.setParameterList(entry.getKey(), (Collection)entry.getValue());
                    continue;
                }
                query.setParameter(entry.getKey(), entry.getValue());
            }
        }
        return query;
    }

    @Override
    @Deprecated
    public List searchByHql(final String hqlStr, final String type, final Map map) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                if (Pagination.isNeedCount().booleanValue()) {
                    int index = hqlStr.indexOf("from");
                    String countSql = hqlStr.substring(index);
                    countSql = "select COUNT(*) " + countSql;
                    Query query0 = session.createQuery(countSql);
                    SearchManagerImpl.this.setQueryValue(query0, type, map);
                    int totalCount = 0;
                    try {
                        totalCount = ((Number)query0.iterate().next()).intValue();
                    }
                    catch (HibernateException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    Pagination.setRowCount(totalCount);
                }
                Query query = session.createQuery(hqlStr);
                SearchManagerImpl.this.setQueryValue(query, type, map);
                query.setFirstResult(Pagination.getFirstResult());
                query.setMaxResults(Pagination.getMaxResults());
                List list = query.list();
                return list;
            }
        });
    }

    private Query setQueryValue(Query query, String type, Map map) {
        if ("timestamp".equals(type)) {
            Object stamp1 = map.get("timestamp1");
            Timestamp stamp2 = (Timestamp)map.get("timestamp2");
            query.setParameter("timestamp1", stamp1);
            query.setParameter("timestamp2", (Object)stamp2);
        }
        if ("string".equals(type)) {
            String now;
            Object startMemberName;
            Object obj = map.get("subject");
            if (obj != null) {
                query.setParameter("subject", obj);
            }
            if ((obj = map.get("docMark")) != null) {
                query.setParameter("docMark", obj);
            }
            if ((obj = map.get("serialNo")) != null) {
                query.setParameter("serialNo", obj);
            }
            if ((startMemberName = map.get("startMemberName")) != null) {
                query.setParameter("startMemberName", startMemberName);
            }
            if ((now = (String)map.get("now")) != null) {
                Date date = new Date();
                Timestamp stamp = new Timestamp(date.getTime());
                query.setParameter("now", (Object)stamp);
            }
        }
        return query;
    }

    @Override
    public List searchBySql(final String sql, final Class clazz) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createSQLQuery(sql).addEntity(clazz).list();
            }
        });
    }

    @Override
    public List searchBySql(final String sql, final Class clazz, final String name0, final Class claxx, final String name1) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                if (Pagination.isNeedCount().booleanValue()) {
                    int index = sql.indexOf("from");
                    String countSql = sql.substring(index);
                    countSql = "select COUNT(*) as myCount " + countSql;
                    SQLQuery query0 = session.createSQLQuery(countSql);
                    int totalCount = ((Number)query0.addScalar("myCount", (Type)Hibernate.INTEGER).uniqueResult()).intValue();
                    Pagination.setRowCount(totalCount);
                }
                SQLQuery query = session.createSQLQuery(sql);
                query.setFirstResult(Pagination.getFirstResult());
                query.setMaxResults(Pagination.getMaxResults());
                query.addEntity(name0, clazz).addEntity(name1, claxx);
                return query.list();
            }
        });
    }

    @Override
    public List searchByHql(final String hqlStr, final Map<String, Object> parameterMap, final boolean isPaginate) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                if (isPaginate) {
                    String tempCountSql = hqlStr.toLowerCase();
                    int fromIndex = tempCountSql.indexOf("from");
                    if (fromIndex > -1) {
                        int orderByIndex = tempCountSql.indexOf("order by");
                        String countSql = null;
                        countSql = orderByIndex > 0 ? hqlStr.substring(fromIndex, orderByIndex) : hqlStr.substring(fromIndex);
                        countSql = "select COUNT(*) " + countSql;
                        Query query0 = session.createQuery(countSql);
                        SearchManagerImpl.this.setQueryValue(query0, parameterMap);
                        List objects = query0.list();
                        int totalCount = 0;
                        totalCount = tempCountSql.indexOf("group by") > 0 ? (objects == null || objects.isEmpty() ? 0 : objects.size()) : ((Number)query0.iterate().next()).intValue();
                        Pagination.setRowCount(totalCount);
                    }
                    Query query = session.createQuery(hqlStr);
                    SearchManagerImpl.this.setQueryValue(query, parameterMap);
                    query.setFirstResult(Pagination.getFirstResult());
                    query.setMaxResults(Pagination.getMaxResults());
                    List list = query.list();
                    return list;
                }
                Query query = session.createQuery(hqlStr);
                SearchManagerImpl.this.setQueryValue(query, parameterMap);
                List list = query.list();
                return list;
            }
        });
    }

    @Override
    public List searchByHql(String hqlStr, int firstResult, int maxResults, Map<String, Object> namedParameterMap, Object ... indexParameter) {
        return this.find(hqlStr, firstResult, maxResults, namedParameterMap, indexParameter);
    }
}

