/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.datasource.CtpDynamicDataSource;
import com.seeyon.ctp.datasource.annotation.ProcessInDataSource;
import com.seeyon.ctp.util.ServerDetector;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.springframework.beans.BeansException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.ClassUtils;

public class CTPBeanFactory
extends DefaultListableBeanFactory {
    private static final Log LOGGER = CtpLogFactory.getLog(CTPBeanFactory.class);
    private static final Set<String> excludeBeanNames = new HashSet<String>();

    public CTPBeanFactory() {
    }

    public CTPBeanFactory(BeanFactory parentBeanFactory) {
        super(parentBeanFactory);
    }

    public BeanDefinition getBeanDefinition(String beanName) throws NoSuchBeanDefinitionException {
        BeanDefinition bd = null;
        try {
            bd = super.getBeanDefinition(beanName);
        }
        catch (NoSuchBeanDefinitionException e) {
            if (excludeBeanNames.contains(beanName)) {
                throw e;
            }
            LOGGER.warn((Object)("***** No bean found with name\uff1a" + beanName));
        }
        return bd;
    }

    protected RootBeanDefinition getMergedBeanDefinition(String beanName, BeanDefinition bd, BeanDefinition containingBd) throws BeanDefinitionStoreException {
        if (bd == null) {
            return null;
        }
        return super.getMergedBeanDefinition(beanName, bd, containingBd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T doGetBean(String name, Class<T> requiredType, final Object[] args, boolean typeCheckOnly) throws BeansException {
        Object bean;
        block26: {
            final String beanName = this.transformedBeanName(name);
            Object sharedInstance = this.getSingleton(beanName);
            if (sharedInstance != null && args == null) {
                if (this.logger.isDebugEnabled()) {
                    if (this.isSingletonCurrentlyInCreation(beanName)) {
                        this.logger.debug((Object)("Returning eagerly cached instance of singleton bean '" + beanName + "' that is not fully initialized yet - a consequence of a circular reference"));
                    } else {
                        this.logger.debug((Object)("Returning cached instance of singleton bean '" + beanName + "'"));
                    }
                }
                bean = this.getObjectForBeanInstance(sharedInstance, name, beanName, null);
            } else {
                if (this.isPrototypeCurrentlyInCreation(beanName)) {
                    throw new BeanCurrentlyInCreationException(beanName);
                }
                BeanFactory parentBeanFactory = this.getParentBeanFactory();
                if (parentBeanFactory != null && !this.containsBeanDefinition(beanName)) {
                    String nameToLookup = this.originalBeanName(name);
                    if (args != null) {
                        return (T)parentBeanFactory.getBean(nameToLookup, args);
                    }
                    return (T)parentBeanFactory.getBean(nameToLookup, requiredType);
                }
                if (!typeCheckOnly) {
                    this.markBeanAsCreated(beanName);
                }
                try {
                    final RootBeanDefinition mbd = this.getMergedLocalBeanDefinition(beanName);
                    if (mbd == null) {
                        return null;
                    }
                    this.checkMergedBeanDefinition(mbd, beanName, args);
                    String[] dependsOn = mbd.getDependsOn();
                    if (dependsOn != null) {
                        for (String dependsOnBean : dependsOn) {
                            this.getBean(dependsOnBean);
                            this.registerDependentBean(dependsOnBean, beanName);
                        }
                    }
                    if (mbd.isSingleton()) {
                        sharedInstance = this.getSingleton(beanName, (ObjectFactory)new ObjectFactory<Object>(){

                            public Object getObject() throws BeansException {
                                try {
                                    return CTPBeanFactory.this.createBean(beanName, mbd, args);
                                }
                                catch (BeansException ex) {
                                    CTPBeanFactory.this.destroySingleton(beanName);
                                    CTPBeanFactory.this.handleException(beanName, ex);
                                    throw ex;
                                }
                            }
                        });
                        bean = this.getObjectForBeanInstance(sharedInstance, name, beanName, mbd);
                        break block26;
                    }
                    if (mbd.isPrototype()) {
                        Object prototypeInstance = null;
                        try {
                            this.beforePrototypeCreation(beanName);
                            prototypeInstance = this.createBean(beanName, mbd, args);
                        }
                        finally {
                            this.afterPrototypeCreation(beanName);
                        }
                        bean = this.getObjectForBeanInstance(prototypeInstance, name, beanName, mbd);
                        break block26;
                    }
                    String scopeName = mbd.getScope();
                    Scope scope = this.getRegisteredScope(scopeName);
                    if (scope == null) {
                        throw new IllegalStateException("No Scope registered for scope '" + scopeName + "'");
                    }
                    try {
                        Object scopedInstance = scope.get(beanName, (ObjectFactory)new ObjectFactory<Object>(){

                            public Object getObject() throws BeansException {
                                CTPBeanFactory.this.beforePrototypeCreation(beanName);
                                try {
                                    Object object = CTPBeanFactory.this.createBean(beanName, mbd, args);
                                    return object;
                                }
                                finally {
                                    CTPBeanFactory.this.afterPrototypeCreation(beanName);
                                }
                            }
                        });
                        bean = this.getObjectForBeanInstance(scopedInstance, name, beanName, mbd);
                    }
                    catch (IllegalStateException ex) {
                        this.handleException(beanName, ex);
                        throw new BeanCreationException(beanName, "Scope '" + scopeName + "' is not active for the current thread; consider defining a scoped proxy for this bean if you intend to refer to it from a singleton", (Throwable)ex);
                    }
                }
                catch (BeansException ex) {
                    this.cleanupAfterBeanCreationFailure(beanName);
                    throw ex;
                }
            }
        }
        if (requiredType != null && bean != null && !requiredType.isAssignableFrom(bean.getClass())) {
            try {
                return (T)this.getTypeConverter().convertIfNecessary(bean, requiredType);
            }
            catch (TypeMismatchException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Failed to convert bean '" + name + "' to required type [" + ClassUtils.getQualifiedName(requiredType) + "]"), (Throwable)ex);
                }
                this.handleException(name, ex);
                throw new BeanNotOfRequiredTypeException(name, requiredType, bean.getClass());
            }
        }
        return (T)bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeInitMethods(String beanName, final Object bean, RootBeanDefinition mbd) throws Throwable {
        String initMethodName;
        boolean isInitializingBean = bean instanceof InitializingBean;
        if (isInitializingBean && (mbd == null || !mbd.isExternallyManagedInitMethod("afterPropertiesSet"))) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking afterPropertiesSet() on bean with name '" + beanName + "'"));
            }
            if (System.getSecurityManager() != null) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            ((InitializingBean)bean).afterPropertiesSet();
                            return null;
                        }
                    }, this.getAccessControlContext());
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
            } else {
                ((InitializingBean)bean).afterPropertiesSet();
            }
        }
        if (!(mbd == null || (initMethodName = mbd.getInitMethodName()) == null || isInitializingBean && "afterPropertiesSet".equals(initMethodName) || mbd.isExternallyManagedInitMethod(initMethodName))) {
            if (SystemEnvironment.isDistributedMode()) {
                boolean processInDataSource = false;
                Annotation[] annotations = bean.getClass().getAnnotations();
                if (annotations != null) {
                    for (Annotation anno : annotations) {
                        if (!(anno instanceof ProcessInDataSource)) continue;
                        processInDataSource = true;
                        CtpDynamicDataSource.setDataSourceKey(((ProcessInDataSource)anno).name().getSource());
                        break;
                    }
                }
                try {
                    this.invokeCustomInitMethod(beanName, bean, mbd);
                }
                finally {
                    if (processInDataSource) {
                        CtpDynamicDataSource.clearDataSourceKey();
                    }
                }
            } else {
                this.invokeCustomInitMethod(beanName, bean, mbd);
            }
        }
    }

    private void handleException(String beanName, Throwable ex) {
        Throwable e1 = ex;
        while (e1.getCause() != null) {
            e1 = e1.getCause();
        }
        this.error("\u521d\u59cb\u5316Spring\u5931\u8d25\uff1a");
        this.error("***********************************************");
        this.error("Bean name\uff1a" + beanName);
        if (e1 instanceof ClassNotFoundException) {
            this.error("\u9519\u8bef\u539f\u56e0\uff1a\u627e\u4e0d\u5230\u7c7b\uff0c\u8bf7\u786e\u8ba4\u60a8\u7684\u73af\u5883\u7684lib\u4e0b\u7684jar\u662f\u5426\u5b8c\u6574\u3002" + e1.getLocalizedMessage());
        } else if (e1 instanceof NotWritablePropertyException) {
            this.error("\u9519\u8bef\u539f\u56e0\uff1abean\u6ca1\u6709\u5bf9\u5e94\u7684\u5c5e\u6027\uff0c\u8bf7\u786e\u8ba4\u60a8\u7684jar\u6587\u4ef6\u7248\u672c\u662f\u5426\u6b63\u786e\u3002" + e1.getLocalizedMessage());
        } else if (e1 instanceof TypeMismatchException) {
            this.error("\u9519\u8bef\u539f\u56e0\uff1a\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u786e\u8ba4\u60a8\u7684jar\u6587\u4ef6\u7248\u672c\u662f\u5426\u6b63\u786e\u3002" + e1.getLocalizedMessage());
        } else if (e1 instanceof NoSuchBeanDefinitionException) {
            this.error("\u9519\u8bef\u539f\u56e0\uff1a\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u540d\u79f0\u7684bean\uff0c\u8bf7\u786e\u8ba4\u60a8\u7684spring xml\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002" + e1.getLocalizedMessage());
        } else {
            this.error("\u9519\u8bef\u539f\u56e0\uff1a" + e1.getLocalizedMessage());
        }
        this.error(ex.getLocalizedMessage());
        LOGGER.error((Object)ex.getLocalizedMessage(), ex);
        if (ServerDetector.isTomcat()) {
            this.error("\u505c\u6b62\u670d\u52a1\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u4ea7\u54c1\u73af\u5883\u3002");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    private void error(String msg) {
        System.err.println(msg);
    }

    static {
        excludeBeanNames.add("themeResolver");
        excludeBeanNames.add("viewNameTranslator");
        excludeBeanNames.add("flashMapManager");
        excludeBeanNames.add("requestDataValueProcessor");
    }
}

