/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.datasource.CtpDynamicDataSource;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import com.seeyon.ctp.util.FlipInfo;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.util.Assert;

public class CTPHibernateTemplate
extends HibernateTemplate {
    private FlipInfo flipInfo = null;

    public FlipInfo getFlipInfo() {
        return this.flipInfo;
    }

    public void setFlipInfo(FlipInfo flipInfo) {
        this.flipInfo = flipInfo;
        this.setMaxResults(flipInfo.getSize());
    }

    public CTPHibernateTemplate() {
    }

    public CTPHibernateTemplate(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    protected void prepareCriteria(Criteria criteria) {
        if (this.flipInfo != null) {
            if (this.flipInfo.isNeedTotal()) {
                this.flipInfo.setTotal(((Number)criteria.setProjection(Projections.rowCount()).uniqueResult()).intValue());
                criteria.setProjection(null);
            }
            if (this.flipInfo.getPage() > this.flipInfo.getPages()) {
                this.flipInfo.setPage(this.flipInfo.getPages());
            }
            if (this.flipInfo.getStartAt() > 0) {
                criteria.setFirstResult(this.flipInfo.getStartAt().intValue());
            }
            for (FlipInfo.SortPair sortPair : this.flipInfo.getSortPairs()) {
                if (sortPair.getSortOrder().equals((Object)FlipInfo.Order.ASC)) {
                    criteria.addOrder(Order.asc((String)sortPair.getSortField()));
                    continue;
                }
                criteria.addOrder(Order.desc((String)sortPair.getSortField()));
            }
        }
        super.prepareCriteria(criteria);
    }

    protected void prepareQuery(final Query queryObject, final Object params) {
        if (this.flipInfo != null) {
            if (this.flipInfo.isNeedTotal()) {
                List objects = this.executeWithNativeSession(new HibernateCallback<List>(){

                    public List doInHibernate(org.hibernate.Session session) throws HibernateException {
                        String countSQL = CTPHibernateTemplate.countSQL(queryObject.getQueryString().trim());
                        Query queryObj = session.createQuery(countSQL);
                        if (params != null) {
                            if (params instanceof Map) {
                                Map paramsMap = (Map)params;
                                int i = 0;
                                for (String key : paramsMap.keySet()) {
                                    CTPHibernateTemplate.this.applyNamedParameterToQuery(queryObj, key, paramsMap.get(key));
                                    ++i;
                                }
                            } else {
                                queryObj.setProperties(params);
                            }
                        }
                        return queryObj.list();
                    }
                });
                this.flipInfo.setTotal(objects == null || objects.isEmpty() ? 0 : ((Number)objects.get(0)).intValue());
                if (this.flipInfo.isNeedTotal() && this.flipInfo.getTotal() == 0) {
                    this.flipInfo.setPage(new Integer(0));
                } else if (this.flipInfo.getPage() < 1) {
                    this.flipInfo.setPage(new Integer(1));
                } else if (this.flipInfo.getPage() > this.flipInfo.getPages()) {
                    this.flipInfo.setPage(this.flipInfo.getPages());
                }
            }
            if (this.flipInfo.getStartAt() > 0) {
                queryObject.setFirstResult(this.flipInfo.getStartAt().intValue());
            }
        }
        super.prepareQuery(queryObject);
    }

    public List findByNamedQueryAndNamedParam(String queryName, Map params) throws DataAccessException {
        return this.findBy(queryName, params, true);
    }

    public List findByNamedParam(String queryString, Map params) throws DataAccessException {
        return this.findBy(queryString, params, false);
    }

    public List findByValueBean(String queryString, Object valueBean) throws DataAccessException {
        return this.findByValueBean(queryString, valueBean, false);
    }

    public List findByNamedQueryAndValueBean(String queryName, Object valueBean) throws DataAccessException {
        return this.findByValueBean(queryName, valueBean, true);
    }

    private List findBy(final String query, final Map params, final boolean namedQuery) throws DataAccessException {
        return this.executeWithNativeSession(new HibernateCallback<List>(){

            public List doInHibernate(org.hibernate.Session session) throws HibernateException {
                Query queryObject = namedQuery ? session.getNamedQuery(query) : session.createQuery(query);
                if (CTPHibernateTemplate.this.flipInfo != null) {
                    String qstring = queryObject.getQueryString();
                    String sortField = CTPHibernateTemplate.this.flipInfo.getSortField();
                    String sortOrder = CTPHibernateTemplate.this.flipInfo.getSortOrder();
                    if (sortField != null && !"".equals(sortField)) {
                        StringBuilder sqlb = new StringBuilder(qstring);
                        int oidx = qstring.toLowerCase().indexOf("order by");
                        if (oidx != -1) {
                            sqlb.delete(oidx, sqlb.length());
                        }
                        sqlb.append(" order by ");
                        sqlb.append(sortField);
                        if (sortOrder != null) {
                            sqlb.append(" ").append(sortOrder);
                        }
                        qstring = sqlb.toString();
                        queryObject = session.createQuery(qstring);
                    }
                }
                if (params != null) {
                    int i = 0;
                    for (String key : params.keySet()) {
                        CTPHibernateTemplate.this.applyNamedParameterToQuery(queryObject, key, params.get(key));
                        ++i;
                    }
                }
                CTPHibernateTemplate.this.prepareQuery(queryObject, params);
                return queryObject.list();
            }
        });
    }

    private List findByValueBean(final String query, final Object valueBean, final boolean namedQuery) throws DataAccessException {
        return this.executeWithNativeSession(new HibernateCallback<List>(){

            public List doInHibernate(org.hibernate.Session session) throws HibernateException {
                Query queryObject = namedQuery ? session.getNamedQuery(query) : session.createQuery(query);
                queryObject.setProperties(valueBean);
                CTPHibernateTemplate.this.prepareQuery(queryObject, valueBean);
                return queryObject.list();
            }
        });
    }

    public static String countSQL(String hqlStr) {
        String tempCountSql = hqlStr.toLowerCase();
        StringBuilder countSqlBuf = new StringBuilder();
        boolean isDistinct = false;
        String countPropertiesName = "*";
        int selectIndex = tempCountSql.indexOf("select");
        int fromIndex = tempCountSql.indexOf("from ");
        String countSql = null;
        if (fromIndex != -1) {
            String tmpStr;
            int distinctIndex;
            if (selectIndex != -1 && (distinctIndex = (tmpStr = tempCountSql.substring(0, fromIndex)).indexOf("distinct")) != -1) {
                isDistinct = true;
                tmpStr = tmpStr.substring(distinctIndex += 9);
                int dotIndex = tmpStr.indexOf(44);
                int kIndex = tmpStr.indexOf(41);
                countPropertiesName = dotIndex != -1 && dotIndex > kIndex ? hqlStr.substring(distinctIndex, distinctIndex + dotIndex) : hqlStr.substring(distinctIndex, fromIndex - 1);
            }
            int orderByIndex = tempCountSql.indexOf("order by");
            countSqlBuf.append("select count(").append(isDistinct ? "distinct " : "");
            countSqlBuf.append(countPropertiesName).append(") ");
            if (orderByIndex > 0) {
                countSqlBuf.append(hqlStr.substring(fromIndex, orderByIndex));
            } else {
                countSqlBuf.append(hqlStr.substring(fromIndex));
            }
            countSql = countSqlBuf.toString();
            int whereIndex = tempCountSql.indexOf(" where ");
            if (whereIndex != -1 && (tmpStr = hqlStr.substring(fromIndex + 4, whereIndex)).contains(",")) {
                String[] tables = tmpStr.split(",");
                for (int i = 1; i < tables.length; ++i) {
                    String tableAlias;
                    String whereSql;
                    int aliasIndex;
                    String tablePair = tables[i];
                    String[] tableArray = tablePair.split(" as ");
                    if (tableArray.length != 2 || (aliasIndex = (whereSql = orderByIndex == -1 ? hqlStr.substring(whereIndex) : hqlStr.substring(whereIndex, orderByIndex)).indexOf((tableAlias = tableArray[1].trim()) + ".")) != -1 && aliasIndex != whereSql.lastIndexOf(tableAlias + ".")) continue;
                    String regex1 = ",\\s*(\\w*\\.)*\\w*\\s*(as)?\\s*" + tableAlias;
                    String regex2 = "\\w*\\.\\w*\\s*=\\s*" + tableAlias + "\\.\\w*";
                    String regex3 = tableAlias + "\\.\\w*\\s*=\\s*\\w*\\.\\w*";
                    if ((countSql = countSql.replaceAll(regex2, "1=1").replaceAll(regex3, "1=1")).contains(tableAlias + ".")) continue;
                    countSql = countSql.replaceAll(regex1, "");
                }
            }
        }
        return countSql;
    }

    public int bulkUpdate(final String hql, final Map<String, Object> nameParameters) {
        return this.executeWithNativeSession(new HibernateCallback<Integer>(){

            public Integer doInHibernate(org.hibernate.Session session) throws HibernateException {
                Query queryObject = session.createQuery(hql);
                if (nameParameters != null) {
                    Set entries = nameParameters.entrySet();
                    for (Map.Entry entry : entries) {
                        String name = (String)entry.getKey();
                        Object value = entry.getValue();
                        if (value instanceof Collection) {
                            queryObject.setParameterList(name, (Collection)value);
                            continue;
                        }
                        if (value instanceof Object[]) {
                            queryObject.setParameterList((String)entry.getKey(), (Object[])value);
                            continue;
                        }
                        queryObject.setParameter((String)entry.getKey(), value);
                    }
                }
                return queryObject.executeUpdate();
            }
        });
    }

    public <T> T execute(HibernateCallback<T> action) throws DataAccessException {
        if (SystemEnvironment.isDistributedMode() && !SystemEnvironment.isBaseService() && !DataSourceName.MAIN.getSource().equals(CtpDynamicDataSource.getDataSourceKey())) {
            return this.doExecuteWithNewSession(action);
        }
        return (T)this.doExecute(action, false, false);
    }

    public <T> T executeWithNativeSession(HibernateCallback<T> action) {
        if (SystemEnvironment.isDistributedMode() && !SystemEnvironment.isBaseService() && !DataSourceName.MAIN.getSource().equals(CtpDynamicDataSource.getDataSourceKey())) {
            return this.doExecuteWithNewSession(action);
        }
        return (T)this.doExecute(action, false, true);
    }

    public <T> T executeWithNewSession(HibernateCallback<T> action) {
        if (SystemEnvironment.isDistributedMode() && !SystemEnvironment.isBaseService() && !DataSourceName.MAIN.getSource().equals(CtpDynamicDataSource.getDataSourceKey())) {
            return this.doExecuteWithNewSession(action);
        }
        return (T)super.executeWithNewSession(action);
    }

    private <T> T doExecuteWithNewSession(HibernateCallback<T> action) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        Session session = this.getSessionFactory().openSession();
        try {
            Object result;
            Object object = result = action.doInHibernate((org.hibernate.Session)session);
            return (T)object;
        }
        catch (HibernateException ex) {
            throw this.convertHibernateAccessException(ex);
        }
        catch (SQLException ex) {
            throw this.convertJdbcAccessException(ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            session.flush();
            SessionFactoryUtils.closeSession((org.hibernate.Session)session);
        }
    }
}

