/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.datasource.CtpDynamicDataSource;
import com.seeyon.ctp.datasource.annotation.DataSourceName;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.transaction.support.CallbackPreferringPlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;

public class CTPTransactionInterceptor
extends TransactionInterceptor {
    public CTPTransactionInterceptor() {
    }

    public CTPTransactionInterceptor(PlatformTransactionManager ptm, Properties attributes) {
        super(ptm, attributes);
    }

    public CTPTransactionInterceptor(PlatformTransactionManager ptm, TransactionAttributeSource tas) {
        super(ptm, tas);
    }

    public Object invoke(final MethodInvocation invocation) throws Throwable {
        Class targetClass = invocation.getThis() != null ? AopUtils.getTargetClass((Object)invocation.getThis()) : null;
        return this.invokeWithinTransaction(invocation.getMethod(), targetClass, new TransactionAspectSupport.InvocationCallback(){

            public Object proceedWithInvocation() throws Throwable {
                return invocation.proceed();
            }
        });
    }

    protected Object invokeWithinTransaction(Method method, Class targetClass, final TransactionAspectSupport.InvocationCallback invocation) throws Throwable {
        final Object txAttr = SystemEnvironment.isDistributedMode() && DataSourceName.BASE.getSource().equals(CtpDynamicDataSource.getDataSourceKey()) ? null : this.getTransactionAttributeSource().getTransactionAttribute(method, targetClass);
        final PlatformTransactionManager tm = this.determineTransactionManager((TransactionAttribute)txAttr);
        final String joinpointIdentification = this.methodIdentification(method, targetClass);
        if (txAttr == null || !(tm instanceof CallbackPreferringPlatformTransactionManager)) {
            TransactionAspectSupport.TransactionInfo txInfo = this.createTransactionIfNecessary(tm, (TransactionAttribute)txAttr, joinpointIdentification);
            Object retVal = null;
            try {
                retVal = invocation.proceedWithInvocation();
            }
            catch (Throwable ex) {
                this.completeTransactionAfterThrowing(txInfo, ex);
                throw ex;
            }
            finally {
                this.cleanupTransactionInfo(txInfo);
            }
            this.commitTransactionAfterReturning(txInfo);
            return retVal;
        }
        try {
            Object result = ((CallbackPreferringPlatformTransactionManager)tm).execute((TransactionDefinition)txAttr, (TransactionCallback)new TransactionCallback<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object doInTransaction(TransactionStatus status) {
                    TransactionAspectSupport.TransactionInfo txInfo = CTPTransactionInterceptor.this.prepareTransactionInfo(tm, txAttr, joinpointIdentification, status);
                    try {
                        Object object = invocation.proceedWithInvocation();
                        return object;
                    }
                    catch (Throwable ex) {
                        if (txAttr.rollbackOn(ex)) {
                            if (ex instanceof RuntimeException) {
                                throw (RuntimeException)ex;
                            }
                            throw new ThrowableHolderException(ex);
                        }
                        ThrowableHolder throwableHolder = new ThrowableHolder(ex);
                        return throwableHolder;
                    }
                    finally {
                        CTPTransactionInterceptor.this.cleanupTransactionInfo(txInfo);
                    }
                }
            });
            if (result instanceof ThrowableHolder) {
                throw ((ThrowableHolder)result).getThrowable();
            }
            return result;
        }
        catch (ThrowableHolderException ex) {
            throw ex.getCause();
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.getTransactionManagerBeanName());
        oos.writeObject(this.getTransactionManager());
        oos.writeObject(this.getTransactionAttributeSource());
        oos.writeObject(this.getBeanFactory());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.setTransactionManagerBeanName((String)ois.readObject());
        this.setTransactionManager((PlatformTransactionManager)ois.readObject());
        this.setTransactionAttributeSource((TransactionAttributeSource)ois.readObject());
        this.setBeanFactory((BeanFactory)ois.readObject());
    }

    public static class ThrowableHolderException
    extends RuntimeException {
        public ThrowableHolderException(Throwable throwable) {
            super(throwable);
        }

        @Override
        public String toString() {
            return this.getCause().toString();
        }
    }

    public static class ThrowableHolder {
        private final Throwable throwable;

        public ThrowableHolder(Throwable throwable) {
            this.throwable = throwable;
        }

        public final Throwable getThrowable() {
            return this.throwable;
        }
    }
}

