/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.base.relational.connection;

import com.ververica.cdc.connectors.base.config.JdbcSourceConfig;
import com.ververica.cdc.connectors.base.relational.connection.ConnectionPoolId;
import com.ververica.cdc.connectors.base.relational.connection.JdbcConnectionPoolFactory;
import com.ververica.cdc.connectors.base.relational.connection.JdbcConnectionPools;
import com.zaxxer.hikari.HikariDataSource;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcConnectionFactory
implements JdbcConnection.ConnectionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcConnectionFactory.class);
    private final JdbcSourceConfig sourceConfig;
    private final JdbcConnectionPoolFactory jdbcConnectionPoolFactory;

    public JdbcConnectionFactory(JdbcSourceConfig sourceConfig, JdbcConnectionPoolFactory jdbcConnectionPoolFactory) {
        this.sourceConfig = sourceConfig;
        this.jdbcConnectionPoolFactory = jdbcConnectionPoolFactory;
    }

    @Override
    public Connection connect(JdbcConfiguration config) throws SQLException {
        int connectRetryTimes = this.sourceConfig.getConnectMaxRetries();
        ConnectionPoolId connectionPoolId = new ConnectionPoolId(this.sourceConfig.getHostname(), this.sourceConfig.getPort(), this.sourceConfig.getUsername());
        HikariDataSource dataSource = JdbcConnectionPools.getInstance(this.jdbcConnectionPoolFactory).getOrCreateConnectionPool(connectionPoolId, this.sourceConfig);
        for (int i2 = 0; i2 < connectRetryTimes; ++i2) {
            try {
                return dataSource.getConnection();
            }
            catch (SQLException e2) {
                if (i2 < connectRetryTimes - 1) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException ie) {
                        throw new FlinkRuntimeException("Failed to get connection, interrupted while doing another attempt", (Throwable)ie);
                    }
                } else {
                    LOG.error("Get connection failed after retry {} times", (Object)(i2 + 1));
                    throw new FlinkRuntimeException((Throwable)e2);
                }
                LOG.warn("Get connection failed, retry times {}", (Object)(i2 + 1));
                continue;
            }
        }
        return dataSource.getConnection();
    }
}

