/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.base.relational.connection;

import com.ververica.cdc.connectors.base.config.JdbcSourceConfig;
import com.ververica.cdc.connectors.base.relational.connection.ConnectionPoolId;
import com.ververica.cdc.connectors.base.relational.connection.ConnectionPools;
import com.ververica.cdc.connectors.base.relational.connection.JdbcConnectionPoolFactory;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcConnectionPools
implements ConnectionPools<HikariDataSource, JdbcSourceConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcConnectionPools.class);
    private static JdbcConnectionPools instance;
    private final Map<ConnectionPoolId, HikariDataSource> pools = new HashMap<ConnectionPoolId, HikariDataSource>();
    private static JdbcConnectionPoolFactory jdbcConnectionPoolFactory;

    private JdbcConnectionPools() {
    }

    public static synchronized JdbcConnectionPools getInstance(JdbcConnectionPoolFactory jdbcConnectionPoolFactory) {
        if (instance == null) {
            JdbcConnectionPools.jdbcConnectionPoolFactory = jdbcConnectionPoolFactory;
            instance = new JdbcConnectionPools();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HikariDataSource getOrCreateConnectionPool(ConnectionPoolId poolId, JdbcSourceConfig sourceConfig) {
        Map<ConnectionPoolId, HikariDataSource> map = this.pools;
        synchronized (map) {
            if (!this.pools.containsKey(poolId)) {
                LOG.info("Create and register connection pool {}", (Object)poolId);
                this.pools.put(poolId, jdbcConnectionPoolFactory.createPooledDataSource(sourceConfig));
            }
            return this.pools.get(poolId);
        }
    }
}

