/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.base.source.assigner.state;

import com.ververica.cdc.connectors.base.source.assigner.state.HybridPendingSplitsState;
import com.ververica.cdc.connectors.base.source.assigner.state.PendingSplitsState;
import com.ververica.cdc.connectors.base.source.assigner.state.SnapshotPendingSplitsState;
import com.ververica.cdc.connectors.base.source.assigner.state.StreamPendingSplitsState;
import com.ververica.cdc.connectors.base.source.meta.offset.Offset;
import com.ververica.cdc.connectors.base.source.meta.split.SchemalessSnapshotSplit;
import com.ververica.cdc.connectors.base.source.meta.split.SnapshotSplit;
import com.ververica.cdc.connectors.base.source.meta.split.SourceSplitBase;
import com.ververica.cdc.connectors.base.source.meta.split.SourceSplitSerializer;
import com.ververica.cdc.connectors.base.utils.SerializerUtils;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;

public class PendingSplitsStateSerializer
implements SimpleVersionedSerializer<PendingSplitsState> {
    private static final int VERSION = 5;
    private static final ThreadLocal<DataOutputSerializer> SERIALIZER_CACHE = ThreadLocal.withInitial(() -> new DataOutputSerializer(64));
    private static final int SNAPSHOT_PENDING_SPLITS_STATE_FLAG = 1;
    private static final int STREAM_PENDING_SPLITS_STATE_FLAG = 2;
    private static final int HYBRID_PENDING_SPLITS_STATE_FLAG = 3;
    private final SourceSplitSerializer splitSerializer;

    public PendingSplitsStateSerializer(SourceSplitSerializer splitSerializer) {
        this.splitSerializer = splitSerializer;
    }

    public int getVersion() {
        return 5;
    }

    public byte[] serialize(PendingSplitsState state) throws IOException {
        if (state.serializedFormCache != null) {
            return state.serializedFormCache;
        }
        DataOutputSerializer out = SERIALIZER_CACHE.get();
        out.writeInt(this.splitSerializer.getVersion());
        if (state instanceof SnapshotPendingSplitsState) {
            out.writeInt(1);
            this.serializeSnapshotPendingSplitsState((SnapshotPendingSplitsState)state, out);
        } else if (state instanceof StreamPendingSplitsState) {
            out.writeInt(2);
            this.serializeStreamPendingSplitsState((StreamPendingSplitsState)state, out);
        } else if (state instanceof HybridPendingSplitsState) {
            out.writeInt(3);
            this.serializeHybridPendingSplitsState((HybridPendingSplitsState)state, out);
        } else {
            throw new IOException("Unsupported to serialize PendingSplitsState class: " + state.getClass().getName());
        }
        byte[] result = out.getCopyOfBuffer();
        state.serializedFormCache = result;
        out.clear();
        return result;
    }

    public PendingSplitsState deserialize(int version, byte[] serialized) throws IOException {
        switch (version) {
            case 1: 
            case 2: {
                return this.deserializeLegacyPendingSplitsState(serialized);
            }
            case 3: 
            case 4: 
            case 5: {
                return this.deserializePendingSplitsState(version, serialized);
            }
        }
        throw new IOException("Unknown version: " + version);
    }

    public PendingSplitsState deserializeLegacyPendingSplitsState(byte[] serialized) throws IOException {
        DataInputDeserializer in = new DataInputDeserializer(serialized);
        int splitVersion = in.readInt();
        int stateFlag = in.readInt();
        if (stateFlag == 1) {
            return this.deserializeLegacySnapshotPendingSplitsState(splitVersion, in);
        }
        if (stateFlag == 3) {
            return this.deserializeLegacyHybridPendingSplitsState(splitVersion, in);
        }
        if (stateFlag == 2) {
            return this.deserializeStreamPendingSplitsState(in);
        }
        throw new IOException("Unsupported to deserialize PendingSplitsState flag: " + stateFlag);
    }

    public PendingSplitsState deserializePendingSplitsState(int version, byte[] serialized) throws IOException {
        DataInputDeserializer in = new DataInputDeserializer(serialized);
        int splitVersion = in.readInt();
        int stateFlag = in.readInt();
        if (stateFlag == 1) {
            return this.deserializeSnapshotPendingSplitsState(version, splitVersion, in);
        }
        if (stateFlag == 3) {
            return this.deserializeHybridPendingSplitsState(version, splitVersion, in);
        }
        if (stateFlag == 2) {
            return this.deserializeStreamPendingSplitsState(in);
        }
        throw new IOException("Unsupported to deserialize PendingSplitsState flag: " + stateFlag);
    }

    private void serializeSnapshotPendingSplitsState(SnapshotPendingSplitsState state, DataOutputSerializer out) throws IOException {
        this.writeTableIds(state.getAlreadyProcessedTables(), out);
        this.writeRemainingSplits(state.getRemainingSplits(), out);
        this.writeAssignedSnapshotSplits(state.getAssignedSplits(), out);
        this.writeFinishedOffsets(state.getSplitFinishedOffsets(), out);
        out.writeBoolean(state.isAssignerFinished());
        this.writeTableIds(state.getRemainingTables(), out);
        out.writeBoolean(state.isTableIdCaseSensitive());
        SourceSplitSerializer.writeTableSchemas(state.getTableSchemas(), out);
    }

    private void serializeHybridPendingSplitsState(HybridPendingSplitsState state, DataOutputSerializer out) throws IOException {
        this.serializeSnapshotPendingSplitsState(state.getSnapshotPendingSplits(), out);
        out.writeBoolean(state.isStreamSplitAssigned());
    }

    private void serializeStreamPendingSplitsState(StreamPendingSplitsState state, DataOutputSerializer out) throws IOException {
        out.writeBoolean(state.isStreamSplitAssigned());
    }

    private SnapshotPendingSplitsState deserializeLegacySnapshotPendingSplitsState(int splitVersion, DataInputDeserializer in) throws IOException {
        List<TableId> alreadyProcessedTables = this.readTableIds(2, in);
        List<SnapshotSplit> remainingSplits = this.readSnapshotSplits(splitVersion, in);
        Map<String, SnapshotSplit> assignedSnapshotSplits = this.readAssignedSnapshotSplits(splitVersion, in);
        ArrayList<SchemalessSnapshotSplit> remainingSchemalessSplits = new ArrayList<SchemalessSnapshotSplit>();
        HashMap<String, SchemalessSnapshotSplit> assignedSchemalessSnapshotSplits = new HashMap<String, SchemalessSnapshotSplit>();
        HashMap<TableId, TableChanges.TableChange> tableSchemas = new HashMap<TableId, TableChanges.TableChange>();
        remainingSplits.forEach(split -> {
            tableSchemas.putAll(split.getTableSchemas());
            remainingSchemalessSplits.add(split.toSchemalessSnapshotSplit());
        });
        assignedSnapshotSplits.entrySet().forEach(entry -> {
            tableSchemas.putAll(((SnapshotSplit)entry.getValue()).getTableSchemas());
            assignedSchemalessSnapshotSplits.put((String)entry.getKey(), ((SnapshotSplit)entry.getValue()).toSchemalessSnapshotSplit());
        });
        Map<String, Offset> finishedOffsets = this.readFinishedOffsets(splitVersion, in);
        boolean isAssignerFinished = in.readBoolean();
        return new SnapshotPendingSplitsState(alreadyProcessedTables, remainingSchemalessSplits, assignedSchemalessSnapshotSplits, tableSchemas, finishedOffsets, isAssignerFinished, new ArrayList<TableId>(), false, false);
    }

    private HybridPendingSplitsState deserializeLegacyHybridPendingSplitsState(int splitVersion, DataInputDeserializer in) throws IOException {
        SnapshotPendingSplitsState snapshotPendingSplitsState = this.deserializeLegacySnapshotPendingSplitsState(splitVersion, in);
        boolean isStreamSplitAssigned = in.readBoolean();
        return new HybridPendingSplitsState(snapshotPendingSplitsState, isStreamSplitAssigned);
    }

    private SnapshotPendingSplitsState deserializeSnapshotPendingSplitsState(int version, int splitVersion, DataInputDeserializer in) throws IOException {
        List<TableId> alreadyProcessedTables = this.readTableIds(version, in);
        List<SnapshotSplit> remainingSplits = this.readSnapshotSplits(splitVersion, in);
        Map<String, SnapshotSplit> assignedSnapshotSplits = this.readAssignedSnapshotSplits(splitVersion, in);
        Map<String, Offset> finishedOffsets = this.readFinishedOffsets(splitVersion, in);
        boolean isAssignerFinished = in.readBoolean();
        List<TableId> remainingTableIds = this.readTableIds(version, in);
        boolean isTableIdCaseSensitive = in.readBoolean();
        ArrayList<SchemalessSnapshotSplit> remainingSchemalessSplits = new ArrayList<SchemalessSnapshotSplit>();
        HashMap<String, SchemalessSnapshotSplit> assignedSchemalessSnapshotSplits = new HashMap<String, SchemalessSnapshotSplit>();
        HashMap<TableId, TableChanges.TableChange> tableSchemas = new HashMap<TableId, TableChanges.TableChange>();
        remainingSplits.forEach(split -> {
            tableSchemas.putAll(split.getTableSchemas());
            remainingSchemalessSplits.add(split.toSchemalessSnapshotSplit());
        });
        assignedSnapshotSplits.entrySet().forEach(entry -> {
            tableSchemas.putAll(((SnapshotSplit)entry.getValue()).getTableSchemas());
            assignedSchemalessSnapshotSplits.put((String)entry.getKey(), ((SnapshotSplit)entry.getValue()).toSchemalessSnapshotSplit());
        });
        if (version >= 4) {
            tableSchemas.putAll(SourceSplitSerializer.readTableSchemas(splitVersion, in));
        }
        return new SnapshotPendingSplitsState(alreadyProcessedTables, remainingSchemalessSplits, assignedSchemalessSnapshotSplits, tableSchemas, finishedOffsets, isAssignerFinished, remainingTableIds, isTableIdCaseSensitive, true);
    }

    private HybridPendingSplitsState deserializeHybridPendingSplitsState(int version, int splitVersion, DataInputDeserializer in) throws IOException {
        SnapshotPendingSplitsState snapshotPendingSplitsState = this.deserializeSnapshotPendingSplitsState(version, splitVersion, in);
        boolean isStreamSplitAssigned = in.readBoolean();
        return new HybridPendingSplitsState(snapshotPendingSplitsState, isStreamSplitAssigned);
    }

    private StreamPendingSplitsState deserializeStreamPendingSplitsState(DataInputDeserializer in) throws IOException {
        return new StreamPendingSplitsState(in.readBoolean());
    }

    private void writeFinishedOffsets(Map<String, Offset> splitsInfo, DataOutputSerializer out) throws IOException {
        int size = splitsInfo.size();
        out.writeInt(size);
        for (Map.Entry<String, Offset> splitInfo : splitsInfo.entrySet()) {
            out.writeUTF(splitInfo.getKey());
            this.splitSerializer.writeOffsetPosition(splitInfo.getValue(), out);
        }
    }

    private Map<String, Offset> readFinishedOffsets(int offsetVersion, DataInputDeserializer in) throws IOException {
        HashMap<String, Offset> splitsInfo = new HashMap<String, Offset>();
        int size = in.readInt();
        for (int i2 = 0; i2 < size; ++i2) {
            String splitId = in.readUTF();
            Offset offsetPosition = this.splitSerializer.readOffsetPosition(offsetVersion, in);
            splitsInfo.put(splitId, offsetPosition);
        }
        return splitsInfo;
    }

    private void writeAssignedSnapshotSplits(Map<String, SchemalessSnapshotSplit> assignedSplits, DataOutputSerializer out) throws IOException {
        int size = assignedSplits.size();
        out.writeInt(size);
        for (Map.Entry<String, SchemalessSnapshotSplit> entry : assignedSplits.entrySet()) {
            out.writeUTF(entry.getKey());
            byte[] splitBytes = this.splitSerializer.serialize(entry.getValue());
            out.writeInt(splitBytes.length);
            out.write(splitBytes);
        }
    }

    private Map<String, SnapshotSplit> readAssignedSnapshotSplits(int splitVersion, DataInputDeserializer in) throws IOException {
        HashMap<String, SnapshotSplit> assignedSplits = new HashMap<String, SnapshotSplit>();
        int size = in.readInt();
        for (int i2 = 0; i2 < size; ++i2) {
            String splitId = in.readUTF();
            SnapshotSplit snapshotSplit = this.readSnapshotSplit(splitVersion, in).asSnapshotSplit();
            assignedSplits.put(splitId, snapshotSplit);
        }
        return assignedSplits;
    }

    private <T extends SourceSplitBase> void writeRemainingSplits(Collection<T> remainingSplits, DataOutputSerializer out) throws IOException {
        int size = remainingSplits.size();
        out.writeInt(size);
        for (SourceSplitBase split : remainingSplits) {
            byte[] splitBytes = this.splitSerializer.serialize(split);
            out.writeInt(splitBytes.length);
            out.write(splitBytes);
        }
    }

    private List<SnapshotSplit> readSnapshotSplits(int splitVersion, DataInputDeserializer in) throws IOException {
        ArrayList<SnapshotSplit> snapshotSplits = new ArrayList<SnapshotSplit>();
        int size = in.readInt();
        for (int i2 = 0; i2 < size; ++i2) {
            SnapshotSplit snapshotSplit = this.readSnapshotSplit(splitVersion, in).asSnapshotSplit();
            snapshotSplits.add(snapshotSplit);
        }
        return snapshotSplits;
    }

    private SourceSplitBase readSnapshotSplit(int splitVersion, DataInputDeserializer in) throws IOException {
        int splitBytesLen = in.readInt();
        byte[] splitBytes = new byte[splitBytesLen];
        in.read(splitBytes);
        return this.splitSerializer.deserialize(splitVersion, splitBytes);
    }

    private void writeTableIds(Collection<TableId> tableIds, DataOutputSerializer out) throws IOException {
        int size = tableIds.size();
        out.writeInt(size);
        for (TableId tableId : tableIds) {
            boolean useCatalogBeforeSchema = SerializerUtils.shouldUseCatalogBeforeSchema(tableId);
            out.writeBoolean(useCatalogBeforeSchema);
            out.writeUTF(tableId.toString());
        }
    }

    private List<TableId> readTableIds(int version, DataInputDeserializer in) throws IOException {
        ArrayList<TableId> tableIds = new ArrayList<TableId>();
        int size = in.readInt();
        for (int i2 = 0; i2 < size; ++i2) {
            boolean useCatalogBeforeSchema = true;
            if (version >= 5) {
                useCatalogBeforeSchema = in.readBoolean();
            }
            String tableIdStr = in.readUTF();
            tableIds.add(TableId.parse(tableIdStr, useCatalogBeforeSchema));
        }
        return tableIds;
    }
}

