/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.base.source.enumerator;

import com.ververica.cdc.connectors.base.config.SourceConfig;
import com.ververica.cdc.connectors.base.source.assigner.SplitAssigner;
import com.ververica.cdc.connectors.base.source.assigner.state.PendingSplitsState;
import com.ververica.cdc.connectors.base.source.meta.events.FinishedSnapshotSplitsAckEvent;
import com.ververica.cdc.connectors.base.source.meta.events.FinishedSnapshotSplitsReportEvent;
import com.ververica.cdc.connectors.base.source.meta.events.FinishedSnapshotSplitsRequestEvent;
import com.ververica.cdc.connectors.base.source.meta.events.StreamSplitMetaEvent;
import com.ververica.cdc.connectors.base.source.meta.events.StreamSplitMetaRequestEvent;
import com.ververica.cdc.connectors.base.source.meta.offset.Offset;
import com.ververica.cdc.connectors.base.source.meta.split.FinishedSnapshotSplitInfo;
import com.ververica.cdc.connectors.base.source.meta.split.SourceSplitBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SourceSplit;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.shaded.guava30.com.google.common.collect.Lists;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class IncrementalSourceEnumerator
implements SplitEnumerator<SourceSplitBase, PendingSplitsState> {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalSourceEnumerator.class);
    private static final long CHECK_EVENT_INTERVAL = 30000L;
    private final SplitEnumeratorContext<SourceSplitBase> context;
    private final SourceConfig sourceConfig;
    private final SplitAssigner splitAssigner;
    private final TreeSet<Integer> readersAwaitingSplit;
    private List<List<FinishedSnapshotSplitInfo>> finishedSnapshotSplitMeta;

    public IncrementalSourceEnumerator(SplitEnumeratorContext<SourceSplitBase> context, SourceConfig sourceConfig, SplitAssigner splitAssigner) {
        this.context = context;
        this.sourceConfig = sourceConfig;
        this.splitAssigner = splitAssigner;
        this.readersAwaitingSplit = new TreeSet();
    }

    public void start() {
        this.splitAssigner.open();
        this.context.callAsync(this::getRegisteredReader, this::syncWithReaders, 30000L, 30000L);
    }

    public void handleSplitRequest(int subtaskId, @Nullable String requesterHostname) {
        if (!this.context.registeredReaders().containsKey(subtaskId)) {
            return;
        }
        this.readersAwaitingSplit.add(subtaskId);
        this.assignSplits();
    }

    public void addSplitsBack(List<SourceSplitBase> splits, int subtaskId) {
        LOG.debug("Incremental Source Enumerator adds splits back: {}", splits);
        this.splitAssigner.addSplits(splits);
    }

    public void addReader(int subtaskId) {
    }

    public void handleSourceEvent(int subtaskId, SourceEvent sourceEvent) {
        if (sourceEvent instanceof FinishedSnapshotSplitsReportEvent) {
            LOG.info("The enumerator receives finished split offsets {} from subtask {}.", (Object)sourceEvent, (Object)subtaskId);
            FinishedSnapshotSplitsReportEvent reportEvent = (FinishedSnapshotSplitsReportEvent)sourceEvent;
            Map<String, Offset> finishedOffsets = reportEvent.getFinishedOffsets();
            this.splitAssigner.onFinishedSplits(finishedOffsets);
            FinishedSnapshotSplitsAckEvent ackEvent = new FinishedSnapshotSplitsAckEvent(new ArrayList<String>(finishedOffsets.keySet()));
            this.context.sendEventToSourceReader(subtaskId, (SourceEvent)ackEvent);
        } else if (sourceEvent instanceof StreamSplitMetaRequestEvent) {
            LOG.debug("The enumerator receives request for stream split meta from subtask {}.", (Object)subtaskId);
            this.sendStreamMetaRequestEvent(subtaskId, (StreamSplitMetaRequestEvent)sourceEvent);
        }
    }

    public PendingSplitsState snapshotState(long checkpointId) {
        return this.splitAssigner.snapshotState(checkpointId);
    }

    public void notifyCheckpointComplete(long checkpointId) {
        this.splitAssigner.notifyCheckpointComplete(checkpointId);
        this.assignSplits();
    }

    public void close() {
        LOG.info("Closing enumerator...");
        this.splitAssigner.close();
    }

    private void assignSplits() {
        Iterator<Integer> awaitingReader = this.readersAwaitingSplit.iterator();
        while (awaitingReader.hasNext()) {
            int nextAwaiting = awaitingReader.next();
            if (!this.context.registeredReaders().containsKey(nextAwaiting)) {
                awaitingReader.remove();
                continue;
            }
            if (this.splitAssigner.isStreamSplitAssigned() && this.sourceConfig.isCloseIdleReaders()) {
                this.context.signalNoMoreSplits(nextAwaiting);
                awaitingReader.remove();
                LOG.info("Close idle reader of subtask {}", (Object)nextAwaiting);
                continue;
            }
            Optional<SourceSplitBase> split = this.splitAssigner.getNext();
            if (!split.isPresent()) break;
            SourceSplitBase sourceSplit = split.get();
            this.context.assignSplit((SourceSplit)sourceSplit, nextAwaiting);
            awaitingReader.remove();
            LOG.info("Assign split {} to subtask {}", (Object)sourceSplit, (Object)nextAwaiting);
        }
    }

    private int[] getRegisteredReader() {
        return this.context.registeredReaders().keySet().stream().mapToInt(Integer::intValue).toArray();
    }

    private void syncWithReaders(int[] subtaskIds, Throwable t2) {
        if (t2 != null) {
            throw new FlinkRuntimeException("Failed to list obtain registered readers due to:", t2);
        }
        if (this.splitAssigner.waitingForFinishedSplits()) {
            for (int subtaskId : subtaskIds) {
                this.context.sendEventToSourceReader(subtaskId, (SourceEvent)new FinishedSnapshotSplitsRequestEvent());
            }
        }
    }

    private void sendStreamMetaRequestEvent(int subTask, StreamSplitMetaRequestEvent requestEvent) {
        if (this.finishedSnapshotSplitMeta == null) {
            List<FinishedSnapshotSplitInfo> finishedSnapshotSplitInfos = this.splitAssigner.getFinishedSplitInfos();
            if (finishedSnapshotSplitInfos.isEmpty()) {
                LOG.error("The assigner offer empty finished split information, this should not happen");
                throw new FlinkRuntimeException("The assigner offer empty finished split information, this should not happen");
            }
            this.finishedSnapshotSplitMeta = Lists.partition(finishedSnapshotSplitInfos, this.sourceConfig.getSplitMetaGroupSize());
        }
        int requestMetaGroupId = requestEvent.getRequestMetaGroupId();
        if (this.finishedSnapshotSplitMeta.size() > requestMetaGroupId) {
            List<FinishedSnapshotSplitInfo> metaToSend = this.finishedSnapshotSplitMeta.get(requestMetaGroupId);
            StreamSplitMetaEvent metadataEvent = new StreamSplitMetaEvent(requestEvent.getSplitId(), requestMetaGroupId, metaToSend.stream().map(FinishedSnapshotSplitInfo::serialize).collect(Collectors.toList()));
            this.context.sendEventToSourceReader(subTask, (SourceEvent)metadataEvent);
        } else {
            LOG.error("Received invalid request meta group id {}, the invalid meta group id range is [0, {}]", (Object)requestMetaGroupId, (Object)(this.finishedSnapshotSplitMeta.size() - 1));
        }
    }
}

