/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oracle;

import com.ververica.cdc.connectors.oracle.util.OracleJdbcUrlUtils;
import com.ververica.cdc.debezium.Validator;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.OracleDriver;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleValidator
implements Validator {
    private static final Logger LOG = LoggerFactory.getLogger(OracleValidator.class);
    private static final long serialVersionUID = 1L;
    private final Properties properties;

    public OracleValidator(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void validate() {
        try (Connection connection = OracleValidator.openConnection(this.properties);){
            DatabaseMetaData metaData = connection.getMetaData();
            if (metaData.getDatabaseMajorVersion() != 19 && metaData.getDatabaseMajorVersion() != 12 && metaData.getDatabaseMajorVersion() != 11) {
                throw new ValidationException(String.format("Currently Flink Oracle CDC connector only supports Oracle whose version is either 11, 12 or 19, but actual is %d.%d.", metaData.getDatabaseMajorVersion(), metaData.getDatabaseMinorVersion()));
            }
        }
        catch (SQLException ex) {
            throw new TableException("Unexpected error while connecting to Oracle and validating", (Throwable)ex);
        }
    }

    public static Connection openConnection(Properties properties) throws SQLException {
        DriverManager.registerDriver(new OracleDriver());
        String url = OracleJdbcUrlUtils.getConnectionUrlWithSid(properties);
        String userName = properties.getProperty("database.user");
        String userpwd = properties.getProperty("database.password");
        return DriverManager.getConnection(url, userName, userpwd);
    }
}

