/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oracle.source.meta.offset;

import com.ververica.cdc.connectors.base.source.meta.offset.Offset;
import io.debezium.connector.oracle.Scn;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class RedoLogOffset
extends Offset {
    private static final long serialVersionUID = 1L;
    public static final String SCN_KEY = "scn";
    public static final String COMMIT_SCN_KEY = "commit_scn";
    public static final String LCR_POSITION_KEY = "lcr_position";
    public static final RedoLogOffset INITIAL_OFFSET = new RedoLogOffset(0L);
    public static final RedoLogOffset NO_STOPPING_OFFSET = new RedoLogOffset(Long.MIN_VALUE);

    public RedoLogOffset(Map<String, String> offset) {
        this.offset = offset;
    }

    public RedoLogOffset(Long scn) {
        this(scn, 0L, null);
    }

    public RedoLogOffset(Long scn, Long commitScn, @Nullable String lcrPosition) {
        HashMap<String, String> offsetMap = new HashMap<String, String>();
        offsetMap.put(SCN_KEY, String.valueOf(scn));
        offsetMap.put(COMMIT_SCN_KEY, String.valueOf(commitScn));
        offsetMap.put(LCR_POSITION_KEY, lcrPosition);
        this.offset = offsetMap;
    }

    public String getScn() {
        return (String)this.offset.get(SCN_KEY);
    }

    public String getCommitScn() {
        return (String)this.offset.get(COMMIT_SCN_KEY);
    }

    public String getLcrPosition() {
        return (String)this.offset.get(LCR_POSITION_KEY);
    }

    @Override
    public int compareTo(Offset offset) {
        RedoLogOffset that = (RedoLogOffset)offset;
        if (NO_STOPPING_OFFSET.equals(that) && NO_STOPPING_OFFSET.equals(this)) {
            return 0;
        }
        if (NO_STOPPING_OFFSET.equals(this)) {
            return 1;
        }
        if (NO_STOPPING_OFFSET.equals(that)) {
            return -1;
        }
        String scnStr = this.getScn();
        String targetScnStr = that.getScn();
        if (StringUtils.isNotEmpty((CharSequence)targetScnStr)) {
            if (StringUtils.isNotEmpty((CharSequence)scnStr)) {
                Scn scn = Scn.valueOf(scnStr);
                Scn targetScn = Scn.valueOf(targetScnStr);
                return scn.compareTo(targetScn);
            }
            return -1;
        }
        if (StringUtils.isNotEmpty((CharSequence)scnStr)) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof RedoLogOffset)) {
            return false;
        }
        RedoLogOffset that = (RedoLogOffset)o2;
        return this.offset.equals(that.offset);
    }
}

