/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oracle.table;

import com.ververica.cdc.connectors.base.options.JdbcSourceOptions;
import com.ververica.cdc.connectors.base.options.SourceOptions;
import com.ververica.cdc.connectors.base.options.StartupOptions;
import com.ververica.cdc.connectors.base.utils.ObjectUtils;
import com.ververica.cdc.connectors.base.utils.OptionUtils;
import com.ververica.cdc.connectors.oracle.source.config.OracleSourceOptions;
import com.ververica.cdc.connectors.oracle.table.OracleTableSource;
import com.ververica.cdc.debezium.table.DebeziumOptions;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.util.Preconditions;

public class OracleTableSourceFactory
implements DynamicTableSourceFactory {
    private static final String IDENTIFIER = "oracle-cdc";
    private static final String SCAN_STARTUP_MODE_VALUE_INITIAL = "initial";
    private static final String SCAN_STARTUP_MODE_VALUE_LATEST = "latest-offset";

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validateExcept(new String[]{"debezium."});
        ReadableConfig config = helper.getOptions();
        String url = (String)config.get(OracleSourceOptions.URL);
        String hostname = (String)config.get(JdbcSourceOptions.HOSTNAME);
        String username = (String)config.get(JdbcSourceOptions.USERNAME);
        String password = (String)config.get(JdbcSourceOptions.PASSWORD);
        String databaseName = (String)config.get(JdbcSourceOptions.DATABASE_NAME);
        String tableName = (String)config.get(JdbcSourceOptions.TABLE_NAME);
        String schemaName = (String)config.get(OracleSourceOptions.SCHEMA_NAME);
        int port = (Integer)config.get(OracleSourceOptions.PORT);
        StartupOptions startupOptions = OracleTableSourceFactory.getStartupOptions(config);
        ResolvedSchema physicalSchema = context.getCatalogTable().getResolvedSchema();
        boolean enableParallelRead = (Boolean)config.get(SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_ENABLED);
        int splitSize = (Integer)config.get(SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE);
        int splitMetaGroupSize = (Integer)config.get(SourceOptions.CHUNK_META_GROUP_SIZE);
        int fetchSize = (Integer)config.get(SourceOptions.SCAN_SNAPSHOT_FETCH_SIZE);
        Duration connectTimeout = (Duration)config.get(JdbcSourceOptions.CONNECT_TIMEOUT);
        int connectMaxRetries = (Integer)config.get(JdbcSourceOptions.CONNECT_MAX_RETRIES);
        int connectionPoolSize = (Integer)config.get(JdbcSourceOptions.CONNECTION_POOL_SIZE);
        double distributionFactorUpper = (Double)config.get(SourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND);
        double distributionFactorLower = (Double)config.get(SourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND);
        String chunkKeyColumn = config.getOptional(JdbcSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_KEY_COLUMN).orElse(null);
        String serverTimezone = (String)config.get(JdbcSourceOptions.SERVER_TIME_ZONE);
        boolean closeIdlerReaders = (Boolean)config.get(JdbcSourceOptions.SCAN_INCREMENTAL_CLOSE_IDLE_READER_ENABLED);
        if (enableParallelRead) {
            this.validateIntegerOption(SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE, splitSize, 1);
            this.validateIntegerOption(SourceOptions.SCAN_SNAPSHOT_FETCH_SIZE, fetchSize, 1);
            this.validateIntegerOption(SourceOptions.CHUNK_META_GROUP_SIZE, splitMetaGroupSize, 1);
            this.validateIntegerOption(JdbcSourceOptions.CONNECTION_POOL_SIZE, connectionPoolSize, 1);
            this.validateIntegerOption(JdbcSourceOptions.CONNECT_MAX_RETRIES, connectMaxRetries, 0);
            this.validateDistributionFactorUpper(distributionFactorUpper);
            this.validateDistributionFactorLower(distributionFactorLower);
        }
        OptionUtils.printOptions(IDENTIFIER, ((Configuration)config).toMap());
        return new OracleTableSource(physicalSchema, url, port, hostname, databaseName, tableName, schemaName, username, password, DebeziumOptions.getDebeziumProperties(context.getCatalogTable().getOptions()), startupOptions, enableParallelRead, splitSize, splitMetaGroupSize, fetchSize, connectTimeout, connectMaxRetries, connectionPoolSize, distributionFactorUpper, distributionFactorLower, chunkKeyColumn, closeIdlerReaders);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(JdbcSourceOptions.USERNAME);
        options.add(JdbcSourceOptions.PASSWORD);
        options.add(JdbcSourceOptions.DATABASE_NAME);
        options.add(JdbcSourceOptions.TABLE_NAME);
        options.add(OracleSourceOptions.SCHEMA_NAME);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(OracleSourceOptions.URL);
        options.add(JdbcSourceOptions.HOSTNAME);
        options.add(OracleSourceOptions.PORT);
        options.add(SourceOptions.SCAN_STARTUP_MODE);
        options.add(SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_ENABLED);
        options.add(SourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE);
        options.add(SourceOptions.CHUNK_META_GROUP_SIZE);
        options.add(SourceOptions.SCAN_SNAPSHOT_FETCH_SIZE);
        options.add(JdbcSourceOptions.CONNECT_TIMEOUT);
        options.add(JdbcSourceOptions.CONNECT_MAX_RETRIES);
        options.add(JdbcSourceOptions.CONNECTION_POOL_SIZE);
        options.add(SourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND);
        options.add(SourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND);
        options.add(JdbcSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_KEY_COLUMN);
        options.add(JdbcSourceOptions.SCAN_INCREMENTAL_CLOSE_IDLE_READER_ENABLED);
        return options;
    }

    private static StartupOptions getStartupOptions(ReadableConfig config) {
        String modeString = (String)config.get(SourceOptions.SCAN_STARTUP_MODE);
        switch (modeString.toLowerCase()) {
            case "initial": {
                return StartupOptions.initial();
            }
            case "latest-offset": {
                return StartupOptions.latest();
            }
        }
        throw new ValidationException(String.format("Invalid value for option '%s'. Supported values are [%s, %s], but was: %s", SourceOptions.SCAN_STARTUP_MODE.key(), SCAN_STARTUP_MODE_VALUE_INITIAL, SCAN_STARTUP_MODE_VALUE_LATEST, modeString));
    }

    private void validateIntegerOption(ConfigOption<Integer> option, int optionValue, int exclusiveMin) {
        Preconditions.checkState((optionValue > exclusiveMin ? 1 : 0) != 0, (Object)String.format("The value of option '%s' must larger than %d, but is %d", option.key(), exclusiveMin, optionValue));
    }

    private void validateDistributionFactorUpper(double distributionFactorUpper) {
        Preconditions.checkState((ObjectUtils.doubleCompare(distributionFactorUpper, 1.0) >= 0 ? 1 : 0) != 0, (Object)String.format("The value of option '%s' must larger than or equals %s, but is %s", SourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND.key(), 1.0, distributionFactorUpper));
    }

    private void validateDistributionFactorLower(double distributionFactorLower) {
        Preconditions.checkState((ObjectUtils.doubleCompare(distributionFactorLower, 0.0) >= 0 && ObjectUtils.doubleCompare(distributionFactorLower, 1.0) <= 0 ? 1 : 0) != 0, (Object)String.format("The value of option '%s' must between %s and %s inclusively, but is %s", SourceOptions.SPLIT_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND.key(), 0.0, 1.0, distributionFactorLower));
    }
}

