/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.ext;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JavaType;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Type;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public class DOMSerializer
extends StdSerializer<Node> {
    protected final TransformerFactory transformerFactory;

    public DOMSerializer() {
        super(Node.class);
        try {
            this.transformerFactory = TransformerFactory.newInstance();
            this.transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception e2) {
            throw new IllegalStateException("Could not instantiate `TransformerFactory`: " + e2.getMessage(), e2);
        }
    }

    @Override
    public void serialize(Node value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        try {
            Transformer transformer = this.transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "no");
            StreamResult result = new StreamResult(new StringWriter());
            transformer.transform(new DOMSource(value), result);
            g2.writeString(result.getWriter().toString());
        }
        catch (TransformerConfigurationException e2) {
            throw new IllegalStateException("Could not create XML Transformer for writing DOM `Node` value: " + e2.getMessage(), e2);
        }
        catch (TransformerException e3) {
            provider.reportMappingProblem(e3, "DOM `Node` value serialization failed: %s", e3.getMessage());
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (visitor != null) {
            visitor.expectAnyFormat(typeHint);
        }
    }
}

