/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.introspect;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

class CollectorBase {
    protected static final AnnotationMap[] NO_ANNOTATION_MAPS = new AnnotationMap[0];
    protected static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    protected final AnnotationIntrospector _intr;

    protected CollectorBase(AnnotationIntrospector intr) {
        this._intr = intr;
    }

    protected final AnnotationCollector collectAnnotations(Annotation[] anns) {
        AnnotationCollector c2 = AnnotationCollector.emptyCollector();
        for (Annotation ann : anns) {
            c2 = c2.addOrOverride(ann);
            if (!this._intr.isAnnotationBundle(ann)) continue;
            c2 = this.collectFromBundle(c2, ann);
        }
        return c2;
    }

    protected final AnnotationCollector collectAnnotations(AnnotationCollector c2, Annotation[] anns) {
        for (Annotation ann : anns) {
            c2 = c2.addOrOverride(ann);
            if (!this._intr.isAnnotationBundle(ann)) continue;
            c2 = this.collectFromBundle(c2, ann);
        }
        return c2;
    }

    protected final AnnotationCollector collectFromBundle(AnnotationCollector c2, Annotation bundle) {
        for (Annotation ann : ClassUtil.findClassAnnotations(bundle.annotationType())) {
            if (CollectorBase._ignorableAnnotation(ann)) continue;
            if (this._intr.isAnnotationBundle(ann)) {
                if (c2.isPresent(ann)) continue;
                c2 = c2.addOrOverride(ann);
                c2 = this.collectFromBundle(c2, ann);
                continue;
            }
            c2 = c2.addOrOverride(ann);
        }
        return c2;
    }

    protected final AnnotationCollector collectDefaultAnnotations(AnnotationCollector c2, Annotation[] anns) {
        for (Annotation ann : anns) {
            if (c2.isPresent(ann)) continue;
            c2 = c2.addOrOverride(ann);
            if (!this._intr.isAnnotationBundle(ann)) continue;
            c2 = this.collectDefaultFromBundle(c2, ann);
        }
        return c2;
    }

    protected final AnnotationCollector collectDefaultFromBundle(AnnotationCollector c2, Annotation bundle) {
        for (Annotation ann : ClassUtil.findClassAnnotations(bundle.annotationType())) {
            if (CollectorBase._ignorableAnnotation(ann) || c2.isPresent(ann)) continue;
            c2 = c2.addOrOverride(ann);
            if (!this._intr.isAnnotationBundle(ann)) continue;
            c2 = this.collectFromBundle(c2, ann);
        }
        return c2;
    }

    protected static final boolean _ignorableAnnotation(Annotation a2) {
        return a2 instanceof Target || a2 instanceof Retention;
    }

    static AnnotationMap _emptyAnnotationMap() {
        return new AnnotationMap();
    }

    static AnnotationMap[] _emptyAnnotationMaps(int count) {
        if (count == 0) {
            return NO_ANNOTATION_MAPS;
        }
        AnnotationMap[] maps = new AnnotationMap[count];
        for (int i2 = 0; i2 < count; ++i2) {
            maps[i2] = CollectorBase._emptyAnnotationMap();
        }
        return maps;
    }
}

