/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.node;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.core.JsonStreamContext;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.core.JsonToken;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.Map;

abstract class NodeCursor
extends JsonStreamContext {
    protected final NodeCursor _parent;
    protected String _currentName;
    protected Object _currentValue;

    public NodeCursor(int contextType, NodeCursor p2) {
        this._type = contextType;
        this._index = -1;
        this._parent = p2;
    }

    @Override
    public final NodeCursor getParent() {
        return this._parent;
    }

    @Override
    public final String getCurrentName() {
        return this._currentName;
    }

    public void overrideCurrentName(String name) {
        this._currentName = name;
    }

    @Override
    public Object getCurrentValue() {
        return this._currentValue;
    }

    @Override
    public void setCurrentValue(Object v2) {
        this._currentValue = v2;
    }

    public abstract JsonToken nextToken();

    public abstract JsonNode currentNode();

    public abstract NodeCursor startObject();

    public abstract NodeCursor startArray();

    public final NodeCursor iterateChildren() {
        JsonNode n2 = this.currentNode();
        if (n2 == null) {
            throw new IllegalStateException("No current node");
        }
        if (n2.isArray()) {
            return new ArrayCursor(n2, this);
        }
        if (n2.isObject()) {
            return new ObjectCursor(n2, this);
        }
        throw new IllegalStateException("Current node of type " + n2.getClass().getName());
    }

    protected static final class ObjectCursor
    extends NodeCursor {
        protected Iterator<Map.Entry<String, JsonNode>> _contents;
        protected Map.Entry<String, JsonNode> _current;
        protected boolean _needEntry;

        public ObjectCursor(JsonNode n2, NodeCursor p2) {
            super(2, p2);
            this._contents = ((ObjectNode)n2).fields();
            this._needEntry = true;
        }

        @Override
        public JsonToken nextToken() {
            if (this._needEntry) {
                if (!this._contents.hasNext()) {
                    this._currentName = null;
                    this._current = null;
                    return JsonToken.END_OBJECT;
                }
                ++this._index;
                this._needEntry = false;
                this._current = this._contents.next();
                this._currentName = this._current == null ? null : this._current.getKey();
                return JsonToken.FIELD_NAME;
            }
            this._needEntry = true;
            return this._current.getValue().asToken();
        }

        @Override
        public JsonNode currentNode() {
            return this._current == null ? null : this._current.getValue();
        }

        @Override
        public NodeCursor startArray() {
            return new ArrayCursor(this.currentNode(), (NodeCursor)this);
        }

        @Override
        public NodeCursor startObject() {
            return new ObjectCursor(this.currentNode(), (NodeCursor)this);
        }
    }

    protected static final class ArrayCursor
    extends NodeCursor {
        protected Iterator<JsonNode> _contents;
        protected JsonNode _currentElement;

        public ArrayCursor(JsonNode n2, NodeCursor p2) {
            super(1, p2);
            this._contents = n2.elements();
        }

        @Override
        public JsonToken nextToken() {
            if (!this._contents.hasNext()) {
                this._currentElement = null;
                return JsonToken.END_ARRAY;
            }
            ++this._index;
            this._currentElement = this._contents.next();
            return this._currentElement.asToken();
        }

        @Override
        public JsonNode currentNode() {
            return this._currentElement;
        }

        @Override
        public NodeCursor startArray() {
            return new ArrayCursor(this._currentElement, (NodeCursor)this);
        }

        @Override
        public NodeCursor startObject() {
            return new ObjectCursor(this._currentElement, (NodeCursor)this);
        }
    }

    protected static final class RootCursor
    extends NodeCursor {
        protected JsonNode _node;
        protected boolean _done = false;

        public RootCursor(JsonNode n2, NodeCursor p2) {
            super(0, p2);
            this._node = n2;
        }

        @Override
        public void overrideCurrentName(String name) {
        }

        @Override
        public JsonToken nextToken() {
            if (!this._done) {
                ++this._index;
                this._done = true;
                return this._node.asToken();
            }
            this._node = null;
            return null;
        }

        @Override
        public JsonNode currentNode() {
            return this._done ? this._node : null;
        }

        @Override
        public NodeCursor startArray() {
            return new ArrayCursor(this._node, (NodeCursor)this);
        }

        @Override
        public NodeCursor startObject() {
            return new ObjectCursor(this._node, (NodeCursor)this);
        }
    }
}

