/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.datatype.jdk8;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.BeanProperty;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JavaType;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.MapperFeature;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.datatype.jdk8.WrappedIOException;
import java.io.IOException;
import java.util.stream.Stream;

public class StreamSerializer
extends StdSerializer<Stream<?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    private final JavaType elemType;
    private final transient JsonSerializer<Object> elemSerializer;

    public StreamSerializer(JavaType streamType, JavaType elemType) {
        this(streamType, elemType, null);
    }

    public StreamSerializer(JavaType streamType, JavaType elemType, JsonSerializer<Object> elemSerializer) {
        super(streamType);
        this.elemType = elemType;
        this.elemSerializer = elemSerializer;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        if (!this.elemType.hasRawClass(Object.class) && (provider.isEnabled(MapperFeature.USE_STATIC_TYPING) || this.elemType.isFinal())) {
            return new StreamSerializer(provider.getTypeFactory().constructParametricType(Stream.class, this.elemType), this.elemType, provider.findPrimaryPropertySerializer(this.elemType, property));
        }
        return this;
    }

    @Override
    public void serialize(Stream<?> stream, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        try (Stream<?> s2 = stream;){
            jgen.writeStartArray();
            s2.forEachOrdered(elem -> {
                try {
                    if (this.elemSerializer == null) {
                        provider.defaultSerializeValue(elem, jgen);
                    } else {
                        this.elemSerializer.serialize(elem, jgen, provider);
                    }
                }
                catch (IOException e2) {
                    throw new WrappedIOException(e2);
                }
            });
            jgen.writeEndArray();
        }
        catch (WrappedIOException e2) {
            throw e2.getCause();
        }
    }
}

