/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.ConfigEntry;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.annotation.InterfaceStability;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

@InterfaceStability.Evolving
public class AlterConfigOp {
    private final ConfigEntry configEntry;
    private final OpType opType;

    public AlterConfigOp(ConfigEntry configEntry, OpType operationType) {
        this.configEntry = configEntry;
        this.opType = operationType;
    }

    public ConfigEntry configEntry() {
        return this.configEntry;
    }

    public OpType opType() {
        return this.opType;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        AlterConfigOp that = (AlterConfigOp)o2;
        return this.opType == that.opType && Objects.equals(this.configEntry, that.configEntry);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.opType, this.configEntry});
    }

    public String toString() {
        return "AlterConfigOp{opType=" + (Object)((Object)this.opType) + ", configEntry=" + this.configEntry + '}';
    }

    public static enum OpType {
        SET(0),
        DELETE(1),
        APPEND(2),
        SUBTRACT(3);

        private static final Map<Byte, OpType> OP_TYPES;
        private final byte id;

        private OpType(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static OpType forId(byte id) {
            return OP_TYPES.get(id);
        }

        static {
            OP_TYPES = Collections.unmodifiableMap(Arrays.stream(OpType.values()).collect(Collectors.toMap(OpType::id, Function.identity())));
        }
    }
}

