/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin;

import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class ProducerState {
    private final long producerId;
    private final int producerEpoch;
    private final int lastSequence;
    private final long lastTimestamp;
    private final OptionalInt coordinatorEpoch;
    private final OptionalLong currentTransactionStartOffset;

    public ProducerState(long producerId, int producerEpoch, int lastSequence, long lastTimestamp, OptionalInt coordinatorEpoch, OptionalLong currentTransactionStartOffset) {
        this.producerId = producerId;
        this.producerEpoch = producerEpoch;
        this.lastSequence = lastSequence;
        this.lastTimestamp = lastTimestamp;
        this.coordinatorEpoch = coordinatorEpoch;
        this.currentTransactionStartOffset = currentTransactionStartOffset;
    }

    public long producerId() {
        return this.producerId;
    }

    public int producerEpoch() {
        return this.producerEpoch;
    }

    public int lastSequence() {
        return this.lastSequence;
    }

    public long lastTimestamp() {
        return this.lastTimestamp;
    }

    public OptionalLong currentTransactionStartOffset() {
        return this.currentTransactionStartOffset;
    }

    public OptionalInt coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ProducerState that = (ProducerState)o2;
        return this.producerId == that.producerId && this.producerEpoch == that.producerEpoch && this.lastSequence == that.lastSequence && this.lastTimestamp == that.lastTimestamp && Objects.equals(this.coordinatorEpoch, that.coordinatorEpoch) && Objects.equals(this.currentTransactionStartOffset, that.currentTransactionStartOffset);
    }

    public int hashCode() {
        return Objects.hash(this.producerId, this.producerEpoch, this.lastSequence, this.lastTimestamp, this.coordinatorEpoch, this.currentTransactionStartOffset);
    }

    public String toString() {
        return "ProducerState(producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", lastSequence=" + this.lastSequence + ", lastTimestamp=" + this.lastTimestamp + ", coordinatorEpoch=" + this.coordinatorEpoch + ", currentTransactionStartOffset=" + this.currentTransactionStartOffset + ')';
    }
}

