/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.consumer;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.consumer.internals.AbstractPartitionAssignor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RangeAssignor
extends AbstractPartitionAssignor {
    public static final String RANGE_ASSIGNOR_NAME = "range";

    @Override
    public String name() {
        return RANGE_ASSIGNOR_NAME;
    }

    private Map<String, List<AbstractPartitionAssignor.MemberInfo>> consumersPerTopic(Map<String, ConsumerPartitionAssignor.Subscription> consumerMetadata) {
        HashMap<String, List<AbstractPartitionAssignor.MemberInfo>> topicToConsumers = new HashMap<String, List<AbstractPartitionAssignor.MemberInfo>>();
        for (Map.Entry<String, ConsumerPartitionAssignor.Subscription> subscriptionEntry : consumerMetadata.entrySet()) {
            String consumerId = subscriptionEntry.getKey();
            AbstractPartitionAssignor.MemberInfo memberInfo = new AbstractPartitionAssignor.MemberInfo(consumerId, subscriptionEntry.getValue().groupInstanceId());
            for (String topic : subscriptionEntry.getValue().topics()) {
                RangeAssignor.put(topicToConsumers, topic, memberInfo);
            }
        }
        return topicToConsumers;
    }

    @Override
    public Map<String, List<TopicPartition>> assign(Map<String, Integer> partitionsPerTopic, Map<String, ConsumerPartitionAssignor.Subscription> subscriptions) {
        Map<String, List<AbstractPartitionAssignor.MemberInfo>> consumersPerTopic = this.consumersPerTopic(subscriptions);
        HashMap<String, List<TopicPartition>> assignment = new HashMap<String, List<TopicPartition>>();
        for (String string : subscriptions.keySet()) {
            assignment.put(string, new ArrayList());
        }
        for (Map.Entry entry : consumersPerTopic.entrySet()) {
            String topic = (String)entry.getKey();
            List consumersForTopic = (List)entry.getValue();
            Integer numPartitionsForTopic = partitionsPerTopic.get(topic);
            if (numPartitionsForTopic == null) continue;
            Collections.sort(consumersForTopic);
            int numPartitionsPerConsumer = numPartitionsForTopic / consumersForTopic.size();
            int consumersWithExtraPartition = numPartitionsForTopic % consumersForTopic.size();
            List<TopicPartition> partitions = AbstractPartitionAssignor.partitions(topic, numPartitionsForTopic);
            int n2 = consumersForTopic.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                int start = numPartitionsPerConsumer * i2 + Math.min(i2, consumersWithExtraPartition);
                int length = numPartitionsPerConsumer + (i2 + 1 > consumersWithExtraPartition ? 0 : 1);
                ((List)assignment.get(((AbstractPartitionAssignor.MemberInfo)consumersForTopic.get((int)i2)).memberId)).addAll(partitions.subList(start, start + length));
            }
        }
        return assignment;
    }
}

