/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.Uuid;
import java.util.Objects;

public class TopicIdPartition {
    private final Uuid topicId;
    private final TopicPartition topicPartition;

    public TopicIdPartition(Uuid topicId, TopicPartition topicPartition) {
        this.topicId = Objects.requireNonNull(topicId, "topicId can not be null");
        this.topicPartition = Objects.requireNonNull(topicPartition, "topicPartition can not be null");
    }

    public TopicIdPartition(Uuid topicId, int partition, String topic) {
        this.topicId = Objects.requireNonNull(topicId, "topicId can not be null");
        this.topicPartition = new TopicPartition(topic, partition);
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public String topic() {
        return this.topicPartition.topic();
    }

    public int partition() {
        return this.topicPartition.partition();
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        TopicIdPartition that = (TopicIdPartition)o2;
        return this.topicId.equals(that.topicId) && this.topicPartition.equals(that.topicPartition);
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.topicId.hashCode();
        result = 31 * result + this.topicPartition.hashCode();
        return result;
    }

    public String toString() {
        return this.topicId + ":" + this.topic() + "-" + this.partition();
    }
}

