/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.provider;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.provider.ConfigProvider;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileConfigProvider
implements ConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(FileConfigProvider.class);

    @Override
    public void configure(Map<String, ?> configs) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ConfigData get(String path) {
        HashMap<String, String> data = new HashMap<String, String>();
        if (path == null) return new ConfigData(data);
        if (path.isEmpty()) {
            return new ConfigData(data);
        }
        try (Reader reader = this.reader(path);){
            Properties properties = new Properties();
            properties.load(reader);
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement().toString();
                String value = properties.getProperty(key);
                if (value == null) continue;
                data.put(key, value);
            }
            ConfigData configData = new ConfigData(data);
            return configData;
        }
        catch (IOException e2) {
            log.error("Could not read properties from file {}", (Object)path, (Object)e2);
            throw new ConfigException("Could not read properties from file " + path);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ConfigData get(String path, Set<String> keys) {
        HashMap<String, String> data = new HashMap<String, String>();
        if (path == null) return new ConfigData(data);
        if (path.isEmpty()) {
            return new ConfigData(data);
        }
        try (Reader reader = this.reader(path);){
            Properties properties = new Properties();
            properties.load(reader);
            for (String key : keys) {
                String value = properties.getProperty(key);
                if (value == null) continue;
                data.put(key, value);
            }
            ConfigData configData = new ConfigData(data);
            return configData;
        }
        catch (IOException e2) {
            log.error("Could not read properties from file {}", (Object)path, (Object)e2);
            throw new ConfigException("Could not read properties from file " + path);
        }
    }

    protected Reader reader(String path) throws IOException {
        return Files.newBufferedReader(Paths.get(path, new String[0]));
    }

    @Override
    public void close() {
    }
}

