/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.internals;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.KafkaFuture;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.internals.KafkaCompletableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class KafkaFutureImpl<T>
extends KafkaFuture<T> {
    private final KafkaCompletableFuture<T> completableFuture;
    private final boolean isDependant;

    public KafkaFutureImpl() {
        this(false, new KafkaCompletableFuture());
    }

    private KafkaFutureImpl(boolean isDependant, KafkaCompletableFuture<T> completableFuture) {
        this.isDependant = isDependant;
        this.completableFuture = completableFuture;
    }

    @Override
    public CompletionStage<T> toCompletionStage() {
        return this.completableFuture;
    }

    @Override
    public <R> KafkaFuture<R> thenApply(KafkaFuture.BaseFunction<T, R> function) {
        CompletionStage appliedFuture = this.completableFuture.thenApply((T value) -> {
            try {
                return function.apply(value);
            }
            catch (Throwable t2) {
                if (t2 instanceof CompletionException) {
                    throw new CompletionException(t2);
                }
                throw t2;
            }
        });
        return new KafkaFutureImpl(true, KafkaFutureImpl.toKafkaCompletableFuture(appliedFuture));
    }

    private static <U> KafkaCompletableFuture<U> toKafkaCompletableFuture(CompletableFuture<U> completableFuture) {
        if (completableFuture instanceof KafkaCompletableFuture) {
            return (KafkaCompletableFuture)completableFuture;
        }
        KafkaCompletableFuture result = new KafkaCompletableFuture();
        completableFuture.whenComplete((T x2, U y2) -> {
            if (y2 != null) {
                result.kafkaCompleteExceptionally((Throwable)y2);
            } else {
                result.kafkaComplete(x2);
            }
        });
        return result;
    }

    @Override
    @Deprecated
    public <R> KafkaFuture<R> thenApply(KafkaFuture.Function<T, R> function) {
        return this.thenApply((KafkaFuture.BaseFunction<T, R>)function);
    }

    @Override
    public KafkaFuture<T> whenComplete(KafkaFuture.BiConsumer<? super T, ? super Throwable> biConsumer) {
        CompletionStage tCompletableFuture = this.completableFuture.whenComplete((T a2, U b2) -> {
            try {
                biConsumer.accept((Object)a2, (Throwable)b2);
            }
            catch (Throwable t2) {
                if (t2 instanceof CompletionException) {
                    throw new CompletionException(t2);
                }
                throw t2;
            }
        });
        return new KafkaFutureImpl(true, KafkaFutureImpl.toKafkaCompletableFuture(tCompletableFuture));
    }

    @Override
    public boolean complete(T newValue) {
        return this.completableFuture.kafkaComplete(newValue);
    }

    @Override
    public boolean completeExceptionally(Throwable newException) {
        return this.completableFuture.kafkaCompleteExceptionally(newException instanceof CompletionException ? new CompletionException(newException) : newException);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.completableFuture.cancel(mayInterruptIfRunning);
    }

    private void maybeThrowCancellationException(Throwable cause) {
        if (cause instanceof CancellationException) {
            throw (CancellationException)cause;
        }
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.completableFuture.get();
        }
        catch (ExecutionException e2) {
            this.maybeThrowCancellationException(e2.getCause());
            throw e2;
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return this.completableFuture.get(timeout, unit);
        }
        catch (ExecutionException e2) {
            this.maybeThrowCancellationException(e2.getCause());
            throw e2;
        }
    }

    @Override
    public T getNow(T valueIfAbsent) throws ExecutionException {
        try {
            return this.completableFuture.getNow(valueIfAbsent);
        }
        catch (CompletionException e2) {
            this.maybeThrowCancellationException(e2.getCause());
            throw new ExecutionException(e2.getCause());
        }
    }

    @Override
    public boolean isCancelled() {
        if (this.isDependant) {
            try {
                this.completableFuture.getNow(null);
                return false;
            }
            catch (Exception e2) {
                return e2 instanceof CompletionException && e2.getCause() instanceof CancellationException;
            }
        }
        return this.completableFuture.isCancelled();
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.completableFuture.isCompletedExceptionally();
    }

    @Override
    public boolean isDone() {
        return this.completableFuture.isDone();
    }

    public String toString() {
        Object value = null;
        Throwable exception = null;
        try {
            value = this.completableFuture.getNow(null);
        }
        catch (CompletionException e2) {
            exception = e2.getCause();
        }
        catch (Exception e3) {
            exception = e3;
        }
        return String.format("KafkaFuture{value=%s,exception=%s,done=%b}", value, exception, exception != null || value != null);
    }
}

