/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.internals;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.InvalidTopicException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;

public class Topic {
    public static final String GROUP_METADATA_TOPIC_NAME = "__consumer_offsets";
    public static final String TRANSACTION_STATE_TOPIC_NAME = "__transaction_state";
    public static final String LEGAL_CHARS = "[a-zA-Z0-9._-]";
    private static final Set<String> INTERNAL_TOPICS = Collections.unmodifiableSet(Utils.mkSet("__consumer_offsets", "__transaction_state"));
    private static final int MAX_NAME_LENGTH = 249;

    public static void validate(String topic) {
        Topic.validate(topic, "Topic name", message -> {
            throw new InvalidTopicException((String)message);
        });
    }

    public static void validate(String name, String logPrefix, Consumer<String> throwableConsumer) {
        if (name.isEmpty()) {
            throwableConsumer.accept(logPrefix + " is illegal, it can't be empty");
        }
        if (".".equals(name) || "..".equals(name)) {
            throwableConsumer.accept(logPrefix + " cannot be \".\" or \"..\"");
        }
        if (name.length() > 249) {
            throwableConsumer.accept(logPrefix + " is illegal, it can't be longer than " + 249 + " characters, " + logPrefix + ": " + name);
        }
        if (!Topic.containsValidPattern(name)) {
            throwableConsumer.accept(logPrefix + " \"" + name + "\" is illegal, it contains a character other than ASCII alphanumerics, '.', '_' and '-'");
        }
    }

    public static boolean isInternal(String topic) {
        return INTERNAL_TOPICS.contains(topic);
    }

    public static boolean hasCollisionChars(String topic) {
        return topic.contains("_") || topic.contains(".");
    }

    public static boolean hasCollision(String topicA, String topicB) {
        return topicA.replace('.', '_').equals(topicB.replace('.', '_'));
    }

    static boolean containsValidPattern(String topic) {
        for (int i2 = 0; i2 < topic.length(); ++i2) {
            boolean validChar;
            char c2 = topic.charAt(i2);
            boolean bl = validChar = c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'Z' || c2 == '.' || c2 == '_' || c2 == '-';
            if (validChar) continue;
            return false;
        }
        return true;
    }
}

