/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiMessage;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Message;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.MessageUtil;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Readable;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Writable;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Field;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Type;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ByteUtils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Bytes;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class JoinGroupRequestData
implements ApiMessage {
    String groupId;
    int sessionTimeoutMs;
    int rebalanceTimeoutMs;
    String memberId;
    String groupInstanceId;
    String protocolType;
    JoinGroupRequestProtocolCollection protocols;
    String reason;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("group_id", Type.STRING, "The group identifier."), new Field("session_timeout_ms", Type.INT32, "The coordinator considers the consumer dead if it receives no heartbeat after this timeout in milliseconds."), new Field("member_id", Type.STRING, "The member id assigned by the group coordinator."), new Field("protocol_type", Type.STRING, "The unique name the for class of protocols implemented by the group we want to join."), new Field("protocols", new ArrayOf(JoinGroupRequestProtocol.SCHEMA_0), "The list of protocols that the member supports."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema SCHEMA_8;
    public static final Schema SCHEMA_9;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 9;

    public JoinGroupRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public JoinGroupRequestData() {
        this.groupId = "";
        this.sessionTimeoutMs = 0;
        this.rebalanceTimeoutMs = -1;
        this.memberId = "";
        this.groupInstanceId = null;
        this.protocolType = "";
        this.protocols = new JoinGroupRequestProtocolCollection(0);
        this.reason = null;
    }

    @Override
    public short apiKey() {
        return 11;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 9;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i2;
        JoinGroupRequestProtocolCollection newCollection;
        int arrayLength;
        int length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field groupId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field groupId had invalid length " + length);
        }
        this.groupId = _readable.readString(length);
        this.sessionTimeoutMs = _readable.readInt();
        this.rebalanceTimeoutMs = _version >= 1 ? _readable.readInt() : -1;
        length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field memberId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field memberId had invalid length " + length);
        }
        this.memberId = _readable.readString(length);
        if (_version >= 5) {
            length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                this.groupInstanceId = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field groupInstanceId had invalid length " + length);
                }
                this.groupInstanceId = _readable.readString(length);
            }
        } else {
            this.groupInstanceId = null;
        }
        length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field protocolType was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field protocolType had invalid length " + length);
        }
        this.protocolType = _readable.readString(length);
        if (_version >= 6) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field protocols was serialized as null");
            }
            newCollection = new JoinGroupRequestProtocolCollection(arrayLength);
            for (i2 = 0; i2 < arrayLength; ++i2) {
                newCollection.add(new JoinGroupRequestProtocol(_readable, _version));
            }
            this.protocols = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field protocols was serialized as null");
            }
            newCollection = new JoinGroupRequestProtocolCollection(arrayLength);
            for (i2 = 0; i2 < arrayLength; ++i2) {
                newCollection.add(new JoinGroupRequestProtocol(_readable, _version));
            }
            this.protocols = newCollection;
        }
        if (_version >= 8) {
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.reason = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field reason had invalid length " + length);
                }
                this.reason = _readable.readString(length);
            }
        } else {
            this.reason = null;
        }
        this._unknownTaggedFields = null;
        if (_version >= 6) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        Object _stringBytes = _cache.getSerializedValue(this.groupId);
        if (_version >= 6) {
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        } else {
            _writable.writeShort((short)((byte[])_stringBytes).length);
        }
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeInt(this.sessionTimeoutMs);
        if (_version >= 1) {
            _writable.writeInt(this.rebalanceTimeoutMs);
        }
        _stringBytes = _cache.getSerializedValue(this.memberId);
        if (_version >= 6) {
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        } else {
            _writable.writeShort((short)((byte[])_stringBytes).length);
        }
        _writable.writeByteArray((byte[])_stringBytes);
        if (_version >= 5) {
            if (this.groupInstanceId == null) {
                if (_version >= 6) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.groupInstanceId);
                if (_version >= 6) {
                    _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                } else {
                    _writable.writeShort((short)((byte[])_stringBytes).length);
                }
                _writable.writeByteArray((byte[])_stringBytes);
            }
        } else if (this.groupInstanceId != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default groupInstanceId at version " + _version);
        }
        _stringBytes = _cache.getSerializedValue(this.protocolType);
        if (_version >= 6) {
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        } else {
            _writable.writeShort((short)((byte[])_stringBytes).length);
        }
        _writable.writeByteArray((byte[])_stringBytes);
        if (_version >= 6) {
            _writable.writeUnsignedVarint(this.protocols.size() + 1);
            _stringBytes = this.protocols.iterator();
            while (_stringBytes.hasNext()) {
                JoinGroupRequestProtocol protocolsElement = (JoinGroupRequestProtocol)_stringBytes.next();
                protocolsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.protocols.size());
            _stringBytes = this.protocols.iterator();
            while (_stringBytes.hasNext()) {
                JoinGroupRequestProtocol protocolsElement = (JoinGroupRequestProtocol)_stringBytes.next();
                protocolsElement.write(_writable, _cache, _version);
            }
        }
        if (_version >= 8) {
            if (this.reason == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.reason);
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                _writable.writeByteArray((byte[])_stringBytes);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 6) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        Object _stringBytes = this.groupId.getBytes(StandardCharsets.UTF_8);
        if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
            throw new RuntimeException("'groupId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.groupId, (byte[])_stringBytes);
        if (_version >= 6) {
            _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
        } else {
            _size.addBytes(((byte[])_stringBytes).length + 2);
        }
        _size.addBytes(4);
        if (_version >= 1) {
            _size.addBytes(4);
        }
        if (((byte[])(_stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8))).length > Short.MAX_VALUE) {
            throw new RuntimeException("'memberId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.memberId, (byte[])_stringBytes);
        if (_version >= 6) {
            _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
        } else {
            _size.addBytes(((byte[])_stringBytes).length + 2);
        }
        if (_version >= 5) {
            if (this.groupInstanceId == null) {
                if (_version >= 6) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                _stringBytes = this.groupInstanceId.getBytes(StandardCharsets.UTF_8);
                if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                    throw new RuntimeException("'groupInstanceId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.groupInstanceId, (byte[])_stringBytes);
                if (_version >= 6) {
                    _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
                } else {
                    _size.addBytes(((byte[])_stringBytes).length + 2);
                }
            }
        }
        if (((byte[])(_stringBytes = this.protocolType.getBytes(StandardCharsets.UTF_8))).length > Short.MAX_VALUE) {
            throw new RuntimeException("'protocolType' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.protocolType, (byte[])_stringBytes);
        if (_version >= 6) {
            _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
        } else {
            _size.addBytes(((byte[])_stringBytes).length + 2);
        }
        if (_version >= 6) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.protocols.size() + 1));
        } else {
            _size.addBytes(4);
        }
        _stringBytes = this.protocols.iterator();
        while (_stringBytes.hasNext()) {
            JoinGroupRequestProtocol protocolsElement = (JoinGroupRequestProtocol)_stringBytes.next();
            protocolsElement.addSize(_size, _cache, _version);
        }
        if (_version >= 8) {
            if (this.reason == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = this.reason.getBytes(StandardCharsets.UTF_8);
                if (((byte[])_stringBytes).length > Short.MAX_VALUE) {
                    throw new RuntimeException("'reason' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.reason, (byte[])_stringBytes);
                _size.addBytes(((byte[])_stringBytes).length + ByteUtils.sizeOfUnsignedVarint(((byte[])_stringBytes).length + 1));
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 6) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JoinGroupRequestData)) {
            return false;
        }
        JoinGroupRequestData other = (JoinGroupRequestData)obj;
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.sessionTimeoutMs != other.sessionTimeoutMs) {
            return false;
        }
        if (this.rebalanceTimeoutMs != other.rebalanceTimeoutMs) {
            return false;
        }
        if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
            return false;
        }
        if (this.groupInstanceId == null ? other.groupInstanceId != null : !this.groupInstanceId.equals(other.groupInstanceId)) {
            return false;
        }
        if (this.protocolType == null ? other.protocolType != null : !this.protocolType.equals(other.protocolType)) {
            return false;
        }
        if (this.protocols == null ? other.protocols != null : !this.protocols.equals(other.protocols)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + this.sessionTimeoutMs;
        hashCode = 31 * hashCode + this.rebalanceTimeoutMs;
        hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
        hashCode = 31 * hashCode + (this.groupInstanceId == null ? 0 : this.groupInstanceId.hashCode());
        hashCode = 31 * hashCode + (this.protocolType == null ? 0 : this.protocolType.hashCode());
        hashCode = 31 * hashCode + (this.protocols == null ? 0 : this.protocols.hashCode());
        hashCode = 31 * hashCode + (this.reason == null ? 0 : this.reason.hashCode());
        return hashCode;
    }

    @Override
    public JoinGroupRequestData duplicate() {
        JoinGroupRequestData _duplicate = new JoinGroupRequestData();
        _duplicate.groupId = this.groupId;
        _duplicate.sessionTimeoutMs = this.sessionTimeoutMs;
        _duplicate.rebalanceTimeoutMs = this.rebalanceTimeoutMs;
        _duplicate.memberId = this.memberId;
        _duplicate.groupInstanceId = this.groupInstanceId == null ? null : this.groupInstanceId;
        _duplicate.protocolType = this.protocolType;
        JoinGroupRequestProtocolCollection newProtocols = new JoinGroupRequestProtocolCollection(this.protocols.size());
        for (JoinGroupRequestProtocol _element : this.protocols) {
            newProtocols.add(_element.duplicate());
        }
        _duplicate.protocols = newProtocols;
        _duplicate.reason = this.reason == null ? null : this.reason;
        return _duplicate;
    }

    public String toString() {
        return "JoinGroupRequestData(groupId=" + (this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", sessionTimeoutMs=" + this.sessionTimeoutMs + ", rebalanceTimeoutMs=" + this.rebalanceTimeoutMs + ", memberId=" + (this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", groupInstanceId=" + (this.groupInstanceId == null ? "null" : "'" + this.groupInstanceId.toString() + "'") + ", protocolType=" + (this.protocolType == null ? "null" : "'" + this.protocolType.toString() + "'") + ", protocols=" + MessageUtil.deepToString(this.protocols.iterator()) + ", reason=" + (this.reason == null ? "null" : "'" + this.reason.toString() + "'") + ")";
    }

    public String groupId() {
        return this.groupId;
    }

    public int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    public String memberId() {
        return this.memberId;
    }

    public String groupInstanceId() {
        return this.groupInstanceId;
    }

    public String protocolType() {
        return this.protocolType;
    }

    public JoinGroupRequestProtocolCollection protocols() {
        return this.protocols;
    }

    public String reason() {
        return this.reason;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public JoinGroupRequestData setGroupId(String v2) {
        this.groupId = v2;
        return this;
    }

    public JoinGroupRequestData setSessionTimeoutMs(int v2) {
        this.sessionTimeoutMs = v2;
        return this;
    }

    public JoinGroupRequestData setRebalanceTimeoutMs(int v2) {
        this.rebalanceTimeoutMs = v2;
        return this;
    }

    public JoinGroupRequestData setMemberId(String v2) {
        this.memberId = v2;
        return this;
    }

    public JoinGroupRequestData setGroupInstanceId(String v2) {
        this.groupInstanceId = v2;
        return this;
    }

    public JoinGroupRequestData setProtocolType(String v2) {
        this.protocolType = v2;
        return this;
    }

    public JoinGroupRequestData setProtocols(JoinGroupRequestProtocolCollection v2) {
        this.protocols = v2;
        return this;
    }

    public JoinGroupRequestData setReason(String v2) {
        this.reason = v2;
        return this;
    }

    static {
        SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("group_id", Type.STRING, "The group identifier."), new Field("session_timeout_ms", Type.INT32, "The coordinator considers the consumer dead if it receives no heartbeat after this timeout in milliseconds."), new Field("rebalance_timeout_ms", Type.INT32, "The maximum time in milliseconds that the coordinator will wait for each member to rejoin when rebalancing the group."), new Field("member_id", Type.STRING, "The member id assigned by the group coordinator."), new Field("protocol_type", Type.STRING, "The unique name the for class of protocols implemented by the group we want to join."), new Field("protocols", new ArrayOf(JoinGroupRequestProtocol.SCHEMA_0), "The list of protocols that the member supports."))));
        SCHEMA_5 = new Schema(new Field("group_id", Type.STRING, "The group identifier."), new Field("session_timeout_ms", Type.INT32, "The coordinator considers the consumer dead if it receives no heartbeat after this timeout in milliseconds."), new Field("rebalance_timeout_ms", Type.INT32, "The maximum time in milliseconds that the coordinator will wait for each member to rejoin when rebalancing the group."), new Field("member_id", Type.STRING, "The member id assigned by the group coordinator."), new Field("group_instance_id", Type.NULLABLE_STRING, "The unique identifier of the consumer instance provided by end user."), new Field("protocol_type", Type.STRING, "The unique name the for class of protocols implemented by the group we want to join."), new Field("protocols", new ArrayOf(JoinGroupRequestProtocol.SCHEMA_0), "The list of protocols that the member supports."));
        SCHEMA_7 = SCHEMA_6 = new Schema(new Field("group_id", Type.COMPACT_STRING, "The group identifier."), new Field("session_timeout_ms", Type.INT32, "The coordinator considers the consumer dead if it receives no heartbeat after this timeout in milliseconds."), new Field("rebalance_timeout_ms", Type.INT32, "The maximum time in milliseconds that the coordinator will wait for each member to rejoin when rebalancing the group."), new Field("member_id", Type.COMPACT_STRING, "The member id assigned by the group coordinator."), new Field("group_instance_id", Type.COMPACT_NULLABLE_STRING, "The unique identifier of the consumer instance provided by end user."), new Field("protocol_type", Type.COMPACT_STRING, "The unique name the for class of protocols implemented by the group we want to join."), new Field("protocols", new CompactArrayOf(JoinGroupRequestProtocol.SCHEMA_6), "The list of protocols that the member supports."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_9 = SCHEMA_8 = new Schema(new Field("group_id", Type.COMPACT_STRING, "The group identifier."), new Field("session_timeout_ms", Type.INT32, "The coordinator considers the consumer dead if it receives no heartbeat after this timeout in milliseconds."), new Field("rebalance_timeout_ms", Type.INT32, "The maximum time in milliseconds that the coordinator will wait for each member to rejoin when rebalancing the group."), new Field("member_id", Type.COMPACT_STRING, "The member id assigned by the group coordinator."), new Field("group_instance_id", Type.COMPACT_NULLABLE_STRING, "The unique identifier of the consumer instance provided by end user."), new Field("protocol_type", Type.COMPACT_STRING, "The unique name the for class of protocols implemented by the group we want to join."), new Field("protocols", new CompactArrayOf(JoinGroupRequestProtocol.SCHEMA_6), "The list of protocols that the member supports."), new Field("reason", Type.COMPACT_NULLABLE_STRING, "The reason why the member (re-)joins the group."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9};
    }

    public static class JoinGroupRequestProtocolCollection
    extends ImplicitLinkedHashMultiCollection<JoinGroupRequestProtocol> {
        public JoinGroupRequestProtocolCollection() {
        }

        public JoinGroupRequestProtocolCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public JoinGroupRequestProtocolCollection(Iterator<JoinGroupRequestProtocol> iterator) {
            super(iterator);
        }

        @Override
        public JoinGroupRequestProtocol find(String name) {
            JoinGroupRequestProtocol _key = new JoinGroupRequestProtocol();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<JoinGroupRequestProtocol> findAll(String name) {
            JoinGroupRequestProtocol _key = new JoinGroupRequestProtocol();
            _key.setName(name);
            return this.findAll(_key);
        }

        public JoinGroupRequestProtocolCollection duplicate() {
            JoinGroupRequestProtocolCollection _duplicate = new JoinGroupRequestProtocolCollection(this.size());
            for (JoinGroupRequestProtocol _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class JoinGroupRequestProtocol
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        byte[] metadata;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 9;

        public JoinGroupRequestProtocol(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public JoinGroupRequestProtocol() {
            this.name = "";
            this.metadata = Bytes.EMPTY;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 9;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of JoinGroupRequestProtocol");
            }
            int length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _version >= 6 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (length < 0) {
                throw new RuntimeException("non-nullable field metadata was serialized as null");
            }
            byte[] newBytes = new byte[length];
            _readable.readArray(newBytes);
            this.metadata = newBytes;
            this._unknownTaggedFields = null;
            if (_version >= 6) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            if (_version >= 6) {
                _writable.writeUnsignedVarint(this.metadata.length + 1);
            } else {
                _writable.writeInt(this.metadata.length);
            }
            _writable.writeByteArray(this.metadata);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 6) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 9) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of JoinGroupRequestProtocol");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            if (_version >= 6) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            _size.addBytes(this.metadata.length);
            if (_version >= 6) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.metadata.length + 1));
            } else {
                _size.addBytes(4);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 6) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof JoinGroupRequestProtocol)) {
                return false;
            }
            JoinGroupRequestProtocol other = (JoinGroupRequestProtocol)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof JoinGroupRequestProtocol)) {
                return false;
            }
            JoinGroupRequestProtocol other = (JoinGroupRequestProtocol)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (!Arrays.equals(this.metadata, other.metadata)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public JoinGroupRequestProtocol duplicate() {
            JoinGroupRequestProtocol _duplicate = new JoinGroupRequestProtocol();
            _duplicate.name = this.name;
            _duplicate.metadata = MessageUtil.duplicate(this.metadata);
            return _duplicate;
        }

        public String toString() {
            return "JoinGroupRequestProtocol(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", metadata=" + Arrays.toString(this.metadata) + ")";
        }

        public String name() {
            return this.name;
        }

        public byte[] metadata() {
            return this.metadata;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public JoinGroupRequestProtocol setName(String v2) {
            this.name = v2;
            return this;
        }

        public JoinGroupRequestProtocol setMetadata(byte[] v2) {
            this.metadata = v2;
            return this;
        }

        @Override
        public void setNext(int v2) {
            this.next = v2;
        }

        @Override
        public void setPrev(int v2) {
            this.prev = v2;
        }

        static {
            SCHEMA_5 = SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The protocol name."), new Field("metadata", Type.BYTES, "The protocol metadata."))))));
            SCHEMA_9 = SCHEMA_8 = (SCHEMA_7 = (SCHEMA_6 = new Schema(new Field("name", Type.COMPACT_STRING, "The protocol name."), new Field("metadata", Type.COMPACT_BYTES, "The protocol metadata."), Field.TaggedFieldsSection.of(new Object[0]))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9};
        }
    }
}

