/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Writable;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ByteUtils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class DataOutputStreamWritable
implements Writable,
Closeable {
    protected final DataOutputStream out;

    public DataOutputStreamWritable(DataOutputStream out) {
        this.out = out;
    }

    @Override
    public void writeByte(byte val) {
        try {
            this.out.writeByte(val);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void writeShort(short val) {
        try {
            this.out.writeShort(val);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void writeInt(int val) {
        try {
            this.out.writeInt(val);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void writeLong(long val) {
        try {
            this.out.writeLong(val);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void writeDouble(double val) {
        try {
            this.out.writeDouble(val);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void writeByteArray(byte[] arr) {
        try {
            this.out.write(arr);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void writeUnsignedVarint(int i2) {
        try {
            ByteUtils.writeUnsignedVarint(i2, this.out);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void writeByteBuffer(ByteBuffer buf) {
        try {
            if (buf.hasArray()) {
                this.out.write(buf.array(), buf.position(), buf.limit());
            } else {
                byte[] bytes = Utils.toArray(buf);
                this.out.write(bytes);
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void writeVarint(int i2) {
        try {
            ByteUtils.writeVarint(i2, this.out);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void writeVarlong(long i2) {
        try {
            ByteUtils.writeVarlong(i2, this.out);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public void close() {
        try {
            this.out.close();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }
}

