/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.RequestHeaderData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.ResponseHeaderData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.BoundField;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.TaggedFields;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Type;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class Protocol {
    private static String indentString(int size) {
        StringBuilder b2 = new StringBuilder(size);
        for (int i2 = 0; i2 < size; ++i2) {
            b2.append(" ");
        }
        return b2.toString();
    }

    private static void schemaToBnfHtml(Schema schema, StringBuilder b2, int indentSize) {
        String indentStr = Protocol.indentString(indentSize);
        LinkedHashMap<String, Type> subTypes = new LinkedHashMap<String, Type>();
        for (BoundField field : schema.fields()) {
            Type type = field.def.type;
            if (type.isArray()) {
                b2.append("[");
                b2.append(field.def.name);
                b2.append("] ");
                if (subTypes.containsKey(field.def.name)) continue;
                subTypes.put(field.def.name, type.arrayElementType().get());
                continue;
            }
            if (type instanceof TaggedFields) {
                b2.append("TAG_BUFFER ");
                continue;
            }
            b2.append(field.def.name);
            b2.append(" ");
            if (subTypes.containsKey(field.def.name)) continue;
            subTypes.put(field.def.name, type);
        }
        b2.append("\n");
        for (Map.Entry entry : subTypes.entrySet()) {
            if (entry.getValue() instanceof Schema) {
                b2.append(indentStr);
                b2.append((String)entry.getKey());
                b2.append(" => ");
                Protocol.schemaToBnfHtml((Schema)entry.getValue(), b2, indentSize + 2);
                continue;
            }
            b2.append(indentStr);
            b2.append((String)entry.getKey());
            b2.append(" => ");
            b2.append(entry.getValue());
            b2.append("\n");
        }
    }

    private static void populateSchemaFields(Schema schema, Set<BoundField> fields) {
        for (BoundField field : schema.fields()) {
            fields.add(field);
            if (field.def.type.isArray()) {
                Type innerType = field.def.type.arrayElementType().get();
                if (!(innerType instanceof Schema)) continue;
                Protocol.populateSchemaFields((Schema)innerType, fields);
                continue;
            }
            if (!(field.def.type instanceof Schema)) continue;
            Protocol.populateSchemaFields((Schema)field.def.type, fields);
        }
    }

    private static void schemaToFieldTableHtml(Schema schema, StringBuilder b2) {
        LinkedHashSet<BoundField> fields = new LinkedHashSet<BoundField>();
        Protocol.populateSchemaFields(schema, fields);
        b2.append("<table class=\"data-table\"><tbody>\n");
        b2.append("<tr>");
        b2.append("<th>Field</th>\n");
        b2.append("<th>Description</th>\n");
        b2.append("</tr>");
        for (BoundField field : fields) {
            b2.append("<tr>\n");
            b2.append("<td>");
            b2.append(field.def.name);
            b2.append("</td>");
            b2.append("<td>");
            b2.append(field.def.docString);
            b2.append("</td>");
            b2.append("</tr>\n");
        }
        b2.append("</table>\n");
    }

    public static String toHtml() {
        int i2;
        StringBuilder b2 = new StringBuilder();
        b2.append("<h5>Headers:</h5>\n");
        for (i2 = 0; i2 < RequestHeaderData.SCHEMAS.length; ++i2) {
            b2.append("<pre>");
            b2.append("Request Header v").append(i2).append(" => ");
            Protocol.schemaToBnfHtml(RequestHeaderData.SCHEMAS[i2], b2, 2);
            b2.append("</pre>\n");
            Protocol.schemaToFieldTableHtml(RequestHeaderData.SCHEMAS[i2], b2);
        }
        for (i2 = 0; i2 < ResponseHeaderData.SCHEMAS.length; ++i2) {
            b2.append("<pre>");
            b2.append("Response Header v").append(i2).append(" => ");
            Protocol.schemaToBnfHtml(ResponseHeaderData.SCHEMAS[i2], b2, 2);
            b2.append("</pre>\n");
            Protocol.schemaToFieldTableHtml(ResponseHeaderData.SCHEMAS[i2], b2);
        }
        for (ApiKeys key : ApiKeys.zkBrokerApis()) {
            b2.append("<h5>");
            b2.append("<a name=\"The_Messages_" + key.name + "\">");
            b2.append(key.name);
            b2.append(" API (Key: ");
            b2.append(key.id);
            b2.append("):</a></h5>\n\n");
            b2.append("<b>Requests:</b><br>\n");
            Schema[] requests = key.messageType.requestSchemas();
            for (int i3 = 0; i3 < requests.length; ++i3) {
                Schema schema = requests[i3];
                if (schema != null) {
                    b2.append("<p>");
                    b2.append("<pre>");
                    b2.append(key.name);
                    b2.append(" Request (Version: ");
                    b2.append(i3);
                    b2.append(") => ");
                    Protocol.schemaToBnfHtml(requests[i3], b2, 2);
                    b2.append("</pre>");
                    Protocol.schemaToFieldTableHtml(requests[i3], b2);
                }
                b2.append("</p>\n");
            }
            b2.append("<b>Responses:</b><br>\n");
            Schema[] responses = key.messageType.responseSchemas();
            for (int i4 = 0; i4 < responses.length; ++i4) {
                Schema schema = responses[i4];
                if (schema != null) {
                    b2.append("<p>");
                    b2.append("<pre>");
                    b2.append(key.name);
                    b2.append(" Response (Version: ");
                    b2.append(i4);
                    b2.append(") => ");
                    Protocol.schemaToBnfHtml(responses[i4], b2, 2);
                    b2.append("</pre>");
                    Protocol.schemaToFieldTableHtml(responses[i4], b2);
                }
                b2.append("</p>\n");
            }
        }
        return b2.toString();
    }

    public static void main(String[] args) {
        System.out.println(Protocol.toHtml());
    }
}

