/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.InvalidRecordException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.KafkaException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.CorruptRecordException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.header.Header;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.AbstractRecordBatch;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.CompressionType;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.FileLogInputStream;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.FileRecords;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.LegacyRecord;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.LogInputStream;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.MutableRecordBatch;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.Record;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.RecordBatch;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.TimestampType;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.AbstractIterator;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.BufferSupplier;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ByteBufferOutputStream;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ByteUtils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.CloseableIterator;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.OptionalLong;

public abstract class AbstractLegacyRecordBatch
extends AbstractRecordBatch
implements Record {
    public abstract LegacyRecord outerRecord();

    @Override
    public long lastOffset() {
        return this.offset();
    }

    @Override
    public boolean isValid() {
        return this.outerRecord().isValid();
    }

    @Override
    public void ensureValid() {
        this.outerRecord().ensureValid();
    }

    @Override
    public int keySize() {
        return this.outerRecord().keySize();
    }

    @Override
    public boolean hasKey() {
        return this.outerRecord().hasKey();
    }

    @Override
    public ByteBuffer key() {
        return this.outerRecord().key();
    }

    @Override
    public int valueSize() {
        return this.outerRecord().valueSize();
    }

    @Override
    public boolean hasValue() {
        return !this.outerRecord().hasNullValue();
    }

    @Override
    public ByteBuffer value() {
        return this.outerRecord().value();
    }

    @Override
    public Header[] headers() {
        return Record.EMPTY_HEADERS;
    }

    @Override
    public boolean hasMagic(byte magic) {
        return magic == this.outerRecord().magic();
    }

    @Override
    public boolean hasTimestampType(TimestampType timestampType) {
        return this.outerRecord().timestampType() == timestampType;
    }

    @Override
    public long checksum() {
        return this.outerRecord().checksum();
    }

    @Override
    public long maxTimestamp() {
        return this.timestamp();
    }

    @Override
    public long timestamp() {
        return this.outerRecord().timestamp();
    }

    @Override
    public TimestampType timestampType() {
        return this.outerRecord().timestampType();
    }

    @Override
    public long baseOffset() {
        return this.iterator().next().offset();
    }

    @Override
    public byte magic() {
        return this.outerRecord().magic();
    }

    @Override
    public CompressionType compressionType() {
        return this.outerRecord().compressionType();
    }

    @Override
    public int sizeInBytes() {
        return this.outerRecord().sizeInBytes() + 12;
    }

    @Override
    public Integer countOrNull() {
        return null;
    }

    public String toString() {
        return "LegacyRecordBatch(offset=" + this.offset() + ", " + this.outerRecord() + ")";
    }

    @Override
    public void writeTo(ByteBuffer buffer) {
        AbstractLegacyRecordBatch.writeHeader(buffer, this.offset(), this.outerRecord().sizeInBytes());
        buffer.put(this.outerRecord().buffer().duplicate());
    }

    @Override
    public long producerId() {
        return -1L;
    }

    @Override
    public short producerEpoch() {
        return -1;
    }

    @Override
    public boolean hasProducerId() {
        return false;
    }

    @Override
    public int sequence() {
        return -1;
    }

    @Override
    public int baseSequence() {
        return -1;
    }

    @Override
    public int lastSequence() {
        return -1;
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    @Override
    public int partitionLeaderEpoch() {
        return -1;
    }

    @Override
    public boolean isControlBatch() {
        return false;
    }

    @Override
    public OptionalLong deleteHorizonMs() {
        return OptionalLong.empty();
    }

    @Override
    public Iterator<Record> iterator() {
        return this.iterator(BufferSupplier.NO_CACHING);
    }

    CloseableIterator<Record> iterator(BufferSupplier bufferSupplier) {
        if (this.isCompressed()) {
            return new DeepRecordsIterator(this, false, Integer.MAX_VALUE, bufferSupplier);
        }
        return new CloseableIterator<Record>(){
            private boolean hasNext = true;

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Record next() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return AbstractLegacyRecordBatch.this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public CloseableIterator<Record> streamingIterator(BufferSupplier bufferSupplier) {
        return this.iterator(bufferSupplier);
    }

    static void writeHeader(ByteBuffer buffer, long offset, int size) {
        buffer.putLong(offset);
        buffer.putInt(size);
    }

    static void writeHeader(DataOutputStream out, long offset, int size) throws IOException {
        out.writeLong(offset);
        out.writeInt(size);
    }

    static class LegacyFileChannelRecordBatch
    extends FileLogInputStream.FileChannelRecordBatch {
        LegacyFileChannelRecordBatch(long offset, byte magic, FileRecords fileRecords, int position, int batchSize) {
            super(offset, magic, fileRecords, position, batchSize);
        }

        @Override
        protected RecordBatch toMemoryRecordBatch(ByteBuffer buffer) {
            return new ByteBufferLegacyRecordBatch(buffer);
        }

        @Override
        public long baseOffset() {
            return this.loadFullBatch().baseOffset();
        }

        @Override
        public OptionalLong deleteHorizonMs() {
            return OptionalLong.empty();
        }

        @Override
        public long lastOffset() {
            return this.offset;
        }

        @Override
        public long producerId() {
            return -1L;
        }

        @Override
        public short producerEpoch() {
            return -1;
        }

        @Override
        public int baseSequence() {
            return -1;
        }

        @Override
        public int lastSequence() {
            return -1;
        }

        @Override
        public Integer countOrNull() {
            return null;
        }

        @Override
        public boolean isTransactional() {
            return false;
        }

        @Override
        public boolean isControlBatch() {
            return false;
        }

        @Override
        public int partitionLeaderEpoch() {
            return -1;
        }

        @Override
        protected int headerSize() {
            return 12 + LegacyRecord.headerSize(this.magic);
        }
    }

    static class ByteBufferLegacyRecordBatch
    extends AbstractLegacyRecordBatch
    implements MutableRecordBatch {
        private final ByteBuffer buffer;
        private final LegacyRecord record;

        ByteBufferLegacyRecordBatch(ByteBuffer buffer) {
            this.buffer = buffer;
            buffer.position(12);
            this.record = new LegacyRecord(buffer.slice());
            buffer.position(0);
        }

        @Override
        public long offset() {
            return this.buffer.getLong(0);
        }

        @Override
        public OptionalLong deleteHorizonMs() {
            return OptionalLong.empty();
        }

        @Override
        public LegacyRecord outerRecord() {
            return this.record;
        }

        @Override
        public void setLastOffset(long offset) {
            this.buffer.putLong(0, offset);
        }

        @Override
        public void setMaxTimestamp(TimestampType timestampType, long timestamp) {
            if (this.record.magic() == 0) {
                throw new UnsupportedOperationException("Cannot set timestamp for a record with magic = 0");
            }
            long currentTimestamp = this.record.timestamp();
            if (this.record.timestampType() == timestampType && currentTimestamp == timestamp) {
                return;
            }
            this.setTimestampAndUpdateCrc(timestampType, timestamp);
        }

        @Override
        public void setPartitionLeaderEpoch(int epoch) {
            throw new UnsupportedOperationException("Magic versions prior to 2 do not support partition leader epoch");
        }

        private void setTimestampAndUpdateCrc(TimestampType timestampType, long timestamp) {
            byte attributes = LegacyRecord.computeAttributes(this.magic(), this.compressionType(), timestampType);
            this.buffer.put(17, attributes);
            this.buffer.putLong(18, timestamp);
            long crc = this.record.computeChecksum();
            ByteUtils.writeUnsignedInt(this.buffer, 12, crc);
        }

        @Override
        public CloseableIterator<Record> skipKeyValueIterator(BufferSupplier bufferSupplier) {
            return CloseableIterator.wrap(this.iterator(bufferSupplier));
        }

        @Override
        public void writeTo(ByteBufferOutputStream outputStream) {
            outputStream.write(this.buffer.duplicate());
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            ByteBufferLegacyRecordBatch that = (ByteBufferLegacyRecordBatch)o2;
            return Objects.equals(this.buffer, that.buffer);
        }

        public int hashCode() {
            return this.buffer != null ? this.buffer.hashCode() : 0;
        }
    }

    private static class BasicLegacyRecordBatch
    extends AbstractLegacyRecordBatch {
        private final LegacyRecord record;
        private final long offset;

        private BasicLegacyRecordBatch(long offset, LegacyRecord record) {
            this.offset = offset;
            this.record = record;
        }

        @Override
        public long offset() {
            return this.offset;
        }

        @Override
        public LegacyRecord outerRecord() {
            return this.record;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            BasicLegacyRecordBatch that = (BasicLegacyRecordBatch)o2;
            return this.offset == that.offset && Objects.equals(this.record, that.record);
        }

        public int hashCode() {
            int result = this.record != null ? this.record.hashCode() : 0;
            result = 31 * result + Long.hashCode(this.offset);
            return result;
        }
    }

    private static class DeepRecordsIterator
    extends AbstractIterator<Record>
    implements CloseableIterator<Record> {
        private final ArrayDeque<AbstractLegacyRecordBatch> innerEntries;
        private final long absoluteBaseOffset;
        private final byte wrapperMagic;

        private DeepRecordsIterator(AbstractLegacyRecordBatch wrapperEntry, boolean ensureMatchingMagic, int maxMessageSize, BufferSupplier bufferSupplier) {
            LegacyRecord wrapperRecord = wrapperEntry.outerRecord();
            this.wrapperMagic = wrapperRecord.magic();
            if (this.wrapperMagic != 0 && this.wrapperMagic != 1) {
                throw new InvalidRecordException("Invalid wrapper magic found in legacy deep record iterator " + this.wrapperMagic);
            }
            CompressionType compressionType = wrapperRecord.compressionType();
            if (compressionType == CompressionType.ZSTD) {
                throw new InvalidRecordException("Invalid wrapper compressionType found in legacy deep record iterator " + this.wrapperMagic);
            }
            ByteBuffer wrapperValue = wrapperRecord.value();
            if (wrapperValue == null) {
                throw new InvalidRecordException("Found invalid compressed record set with null value (magic = " + this.wrapperMagic + ")");
            }
            InputStream stream = compressionType.wrapForInput(wrapperValue, wrapperRecord.magic(), bufferSupplier);
            DataLogInputStream logStream = new DataLogInputStream(stream, maxMessageSize);
            long lastOffsetFromWrapper = wrapperEntry.lastOffset();
            long timestampFromWrapper = wrapperRecord.timestamp();
            this.innerEntries = new ArrayDeque();
            try {
                AbstractLegacyRecordBatch innerEntry;
                while ((innerEntry = (AbstractLegacyRecordBatch)logStream.nextBatch()) != null) {
                    LegacyRecord record = innerEntry.outerRecord();
                    byte magic = record.magic();
                    if (ensureMatchingMagic && magic != this.wrapperMagic) {
                        throw new InvalidRecordException("Compressed message magic " + magic + " does not match wrapper magic " + this.wrapperMagic);
                    }
                    if (magic == 1) {
                        LegacyRecord recordWithTimestamp = new LegacyRecord(record.buffer(), timestampFromWrapper, wrapperRecord.timestampType());
                        innerEntry = new BasicLegacyRecordBatch(innerEntry.lastOffset(), recordWithTimestamp);
                    }
                    this.innerEntries.addLast(innerEntry);
                }
                if (this.innerEntries.isEmpty()) {
                    throw new InvalidRecordException("Found invalid compressed record set with no inner records");
                }
                if (this.wrapperMagic == 1) {
                    if (lastOffsetFromWrapper == 0L) {
                        this.absoluteBaseOffset = 0L;
                    } else {
                        long lastInnerOffset = this.innerEntries.getLast().offset();
                        if (lastOffsetFromWrapper < lastInnerOffset) {
                            throw new InvalidRecordException("Found invalid wrapper offset in compressed v1 message set, wrapper offset '" + lastOffsetFromWrapper + "' is less than the last inner message offset '" + lastInnerOffset + "' and it is not zero.");
                        }
                        this.absoluteBaseOffset = lastOffsetFromWrapper - lastInnerOffset;
                    }
                } else {
                    this.absoluteBaseOffset = -1L;
                }
            }
            catch (IOException e2) {
                throw new KafkaException(e2);
            }
            finally {
                Utils.closeQuietly(stream, "records iterator stream");
            }
        }

        @Override
        protected Record makeNext() {
            if (this.innerEntries.isEmpty()) {
                return (Record)this.allDone();
            }
            AbstractLegacyRecordBatch entry = this.innerEntries.remove();
            if (this.wrapperMagic == 1) {
                long absoluteOffset = this.absoluteBaseOffset + entry.offset();
                entry = new BasicLegacyRecordBatch(absoluteOffset, entry.outerRecord());
            }
            if (entry.isCompressed()) {
                throw new InvalidRecordException("Inner messages must not be compressed");
            }
            return entry;
        }

        @Override
        public void close() {
        }
    }

    private static final class DataLogInputStream
    implements LogInputStream<AbstractLegacyRecordBatch> {
        private final InputStream stream;
        protected final int maxMessageSize;
        private final ByteBuffer offsetAndSizeBuffer;

        DataLogInputStream(InputStream stream, int maxMessageSize) {
            this.stream = stream;
            this.maxMessageSize = maxMessageSize;
            this.offsetAndSizeBuffer = ByteBuffer.allocate(12);
        }

        @Override
        public AbstractLegacyRecordBatch nextBatch() throws IOException {
            this.offsetAndSizeBuffer.clear();
            Utils.readFully(this.stream, this.offsetAndSizeBuffer);
            if (this.offsetAndSizeBuffer.hasRemaining()) {
                return null;
            }
            long offset = this.offsetAndSizeBuffer.getLong(0);
            int size = this.offsetAndSizeBuffer.getInt(8);
            if (size < 14) {
                throw new CorruptRecordException(String.format("Record size is less than the minimum record overhead (%d)", 14));
            }
            if (size > this.maxMessageSize) {
                throw new CorruptRecordException(String.format("Record size exceeds the largest allowable message size (%d).", this.maxMessageSize));
            }
            ByteBuffer batchBuffer = ByteBuffer.allocate(size);
            Utils.readFully(this.stream, batchBuffer);
            if (batchBuffer.hasRemaining()) {
                return null;
            }
            batchBuffer.flip();
            return new BasicLegacyRecordBatch(offset, new LegacyRecord(batchBuffer));
        }
    }
}

