/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.AbstractRecords;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.CompressionType;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.ConvertedRecords;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.MemoryRecords;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.MemoryRecordsBuilder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.Record;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.RecordBatch;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.RecordConversionStats;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.TimestampType;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Time;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class RecordsUtil {
    protected static ConvertedRecords<MemoryRecords> downConvert(Iterable<? extends RecordBatch> batches, byte toMagic, long firstOffset, Time time) {
        ArrayList<RecordBatchAndRecords> recordBatchAndRecordsList = new ArrayList<RecordBatchAndRecords>();
        int totalSizeEstimate = 0;
        long startNanos = time.nanoseconds();
        for (RecordBatch recordBatch : batches) {
            if (toMagic < 2) {
                if (recordBatch.isControlBatch()) continue;
                if (recordBatch.compressionType() == CompressionType.ZSTD) {
                    throw new UnsupportedCompressionTypeException("Down-conversion of zstandard-compressed batches is not supported");
                }
            }
            if (recordBatch.magic() <= toMagic) {
                totalSizeEstimate += recordBatch.sizeInBytes();
                recordBatchAndRecordsList.add(new RecordBatchAndRecords(recordBatch, null, null));
                continue;
            }
            ArrayList<Record> records = new ArrayList<Record>();
            for (Object record : recordBatch) {
                if (toMagic <= 1 && !recordBatch.isCompressed() && record.offset() < firstOffset) continue;
                records.add((Record)record);
            }
            if (records.isEmpty()) continue;
            long baseOffset = recordBatch.magic() >= 2 && toMagic >= 2 ? recordBatch.baseOffset() : ((Record)records.get(0)).offset();
            totalSizeEstimate += AbstractRecords.estimateSizeInBytes(toMagic, baseOffset, recordBatch.compressionType(), records);
            recordBatchAndRecordsList.add(new RecordBatchAndRecords(recordBatch, records, baseOffset));
        }
        ByteBuffer buffer = ByteBuffer.allocate(totalSizeEstimate);
        long l2 = 0L;
        int numRecordsConverted = 0;
        for (RecordBatchAndRecords recordBatchAndRecords : recordBatchAndRecordsList) {
            l2 += (long)recordBatchAndRecords.batch.sizeInBytes();
            if (recordBatchAndRecords.batch.magic() <= toMagic) {
                buffer = Utils.ensureCapacity(buffer, buffer.position() + recordBatchAndRecords.batch.sizeInBytes());
                recordBatchAndRecords.batch.writeTo(buffer);
                continue;
            }
            MemoryRecordsBuilder builder = RecordsUtil.convertRecordBatch(toMagic, buffer, recordBatchAndRecords);
            buffer = builder.buffer();
            l2 += (long)builder.uncompressedBytesWritten();
            numRecordsConverted += builder.numRecords();
        }
        buffer.flip();
        RecordConversionStats stats = new RecordConversionStats(l2, numRecordsConverted, time.nanoseconds() - startNanos);
        return new ConvertedRecords<MemoryRecords>(MemoryRecords.readableRecords(buffer), stats);
    }

    private static MemoryRecordsBuilder convertRecordBatch(byte magic, ByteBuffer buffer, RecordBatchAndRecords recordBatchAndRecords) {
        RecordBatch batch = recordBatchAndRecords.batch;
        TimestampType timestampType = batch.timestampType();
        long logAppendTime = timestampType == TimestampType.LOG_APPEND_TIME ? batch.maxTimestamp() : -1L;
        MemoryRecordsBuilder builder = MemoryRecords.builder(buffer, magic, batch.compressionType(), timestampType, recordBatchAndRecords.baseOffset, logAppendTime);
        for (Record record : recordBatchAndRecords.records) {
            if (magic > 1) {
                builder.append(record);
                continue;
            }
            builder.appendWithOffset(record.offset(), record.timestamp(), record.key(), record.value());
        }
        builder.close();
        return builder;
    }

    private static class RecordBatchAndRecords {
        private final RecordBatch batch;
        private final List<Record> records;
        private final Long baseOffset;

        private RecordBatchAndRecords(RecordBatch batch, List<Record> records, Long baseOffset) {
            this.batch = batch;
            this.records = records;
            this.baseOffset = baseOffset;
        }
    }
}

