/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.replica;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.replica.ReplicaView;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public interface PartitionView {
    public Set<ReplicaView> replicas();

    public ReplicaView leader();

    public static class DefaultPartitionView
    implements PartitionView {
        private final Set<ReplicaView> replicas;
        private final ReplicaView leader;

        public DefaultPartitionView(Set<ReplicaView> replicas, ReplicaView leader) {
            this.replicas = Collections.unmodifiableSet(replicas);
            this.leader = leader;
        }

        @Override
        public Set<ReplicaView> replicas() {
            return this.replicas;
        }

        @Override
        public ReplicaView leader() {
            return this.leader;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            DefaultPartitionView that = (DefaultPartitionView)o2;
            return Objects.equals(this.replicas, that.replicas) && Objects.equals(this.leader, that.leader);
        }

        public int hashCode() {
            return Objects.hash(this.replicas, this.leader);
        }

        public String toString() {
            return "DefaultPartitionView{replicas=" + this.replicas + ", leader=" + this.leader + '}';
        }
    }
}

