/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.AlterPartitionRequestData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.AlterPartitionResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AlterPartitionResponse;
import java.nio.ByteBuffer;

public class AlterPartitionRequest
extends AbstractRequest {
    private final AlterPartitionRequestData data;

    public AlterPartitionRequest(AlterPartitionRequestData data, short apiVersion) {
        super(ApiKeys.ALTER_PARTITION, apiVersion);
        this.data = data;
    }

    @Override
    public AlterPartitionRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e2) {
        return new AlterPartitionResponse(new AlterPartitionResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(e2).code()));
    }

    public static AlterPartitionRequest parse(ByteBuffer buffer, short version) {
        return new AlterPartitionRequest(new AlterPartitionRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterPartitionRequest> {
        private final AlterPartitionRequestData data;

        public Builder(AlterPartitionRequestData data) {
            super(ApiKeys.ALTER_PARTITION);
            this.data = data;
        }

        @Override
        public AlterPartitionRequest build(short version) {
            return new AlterPartitionRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

