/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.BrokerRegistrationRequestData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.BrokerRegistrationResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.BrokerRegistrationResponse;
import java.nio.ByteBuffer;

public class BrokerRegistrationRequest
extends AbstractRequest {
    private final BrokerRegistrationRequestData data;

    public BrokerRegistrationRequest(BrokerRegistrationRequestData data, short version) {
        super(ApiKeys.BROKER_REGISTRATION, version);
        this.data = data;
    }

    @Override
    public BrokerRegistrationRequestData data() {
        return this.data;
    }

    @Override
    public BrokerRegistrationResponse getErrorResponse(int throttleTimeMs, Throwable e2) {
        Errors error = Errors.forException(e2);
        return new BrokerRegistrationResponse(new BrokerRegistrationResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(error.code()));
    }

    public static BrokerRegistrationRequest parse(ByteBuffer buffer, short version) {
        return new BrokerRegistrationRequest(new BrokerRegistrationRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<BrokerRegistrationRequest> {
        private final BrokerRegistrationRequestData data;

        public Builder(BrokerRegistrationRequestData data) {
            super(ApiKeys.BROKER_REGISTRATION);
            this.data = data;
        }

        @Override
        public BrokerRegistrationRequest build(short version) {
            return new BrokerRegistrationRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

