/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.DescribeDelegationTokenRequestData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.DescribeDelegationTokenResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.auth.KafkaPrincipal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeDelegationTokenRequest
extends AbstractRequest {
    private final DescribeDelegationTokenRequestData data;

    public DescribeDelegationTokenRequest(DescribeDelegationTokenRequestData data, short version) {
        super(ApiKeys.DESCRIBE_DELEGATION_TOKEN, version);
        this.data = data;
    }

    @Override
    public DescribeDelegationTokenRequestData data() {
        return this.data;
    }

    public boolean ownersListEmpty() {
        return this.data.owners() != null && this.data.owners().isEmpty();
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e2) {
        return new DescribeDelegationTokenResponse(throttleTimeMs, Errors.forException(e2));
    }

    public static DescribeDelegationTokenRequest parse(ByteBuffer buffer, short version) {
        return new DescribeDelegationTokenRequest(new DescribeDelegationTokenRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeDelegationTokenRequest> {
        private final DescribeDelegationTokenRequestData data;

        public Builder(List<KafkaPrincipal> owners) {
            super(ApiKeys.DESCRIBE_DELEGATION_TOKEN);
            this.data = new DescribeDelegationTokenRequestData().setOwners(owners == null ? null : owners.stream().map(owner -> new DescribeDelegationTokenRequestData.DescribeDelegationTokenOwner().setPrincipalName(owner.getName()).setPrincipalType(owner.getPrincipalType())).collect(Collectors.toList()));
        }

        @Override
        public DescribeDelegationTokenRequest build(short version) {
            return new DescribeDelegationTokenRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

