/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.DescribeProducersRequestData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.DescribeProducersResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.DescribeProducersResponse;
import java.nio.ByteBuffer;

public class DescribeProducersRequest
extends AbstractRequest {
    private final DescribeProducersRequestData data;

    private DescribeProducersRequest(DescribeProducersRequestData data, short version) {
        super(ApiKeys.DESCRIBE_PRODUCERS, version);
        this.data = data;
    }

    @Override
    public DescribeProducersRequestData data() {
        return this.data;
    }

    @Override
    public DescribeProducersResponse getErrorResponse(int throttleTimeMs, Throwable e2) {
        Errors error = Errors.forException(e2);
        DescribeProducersResponseData response = new DescribeProducersResponseData();
        for (DescribeProducersRequestData.TopicRequest topicRequest : this.data.topics()) {
            DescribeProducersResponseData.TopicResponse topicResponse = new DescribeProducersResponseData.TopicResponse().setName(topicRequest.name());
            for (int partitionId : topicRequest.partitionIndexes()) {
                topicResponse.partitions().add(new DescribeProducersResponseData.PartitionResponse().setPartitionIndex(partitionId).setErrorCode(error.code()));
            }
            response.topics().add(topicResponse);
        }
        return new DescribeProducersResponse(response);
    }

    public static DescribeProducersRequest parse(ByteBuffer buffer, short version) {
        return new DescribeProducersRequest(new DescribeProducersRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    @Override
    public String toString(boolean verbose) {
        return this.data.toString();
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeProducersRequest> {
        public final DescribeProducersRequestData data;

        public Builder(DescribeProducersRequestData data) {
            super(ApiKeys.DESCRIBE_PRODUCERS);
            this.data = data;
        }

        public DescribeProducersRequestData.TopicRequest addTopic(String topic) {
            DescribeProducersRequestData.TopicRequest topicRequest = new DescribeProducersRequestData.TopicRequest().setName(topic);
            this.data.topics().add(topicRequest);
            return topicRequest;
        }

        @Override
        public DescribeProducersRequest build(short version) {
            return new DescribeProducersRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

