/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.ListTransactionsRequestData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.ListTransactionsResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.ListTransactionsResponse;
import java.nio.ByteBuffer;

public class ListTransactionsRequest
extends AbstractRequest {
    private final ListTransactionsRequestData data;

    private ListTransactionsRequest(ListTransactionsRequestData data, short version) {
        super(ApiKeys.LIST_TRANSACTIONS, version);
        this.data = data;
    }

    @Override
    public ListTransactionsRequestData data() {
        return this.data;
    }

    @Override
    public ListTransactionsResponse getErrorResponse(int throttleTimeMs, Throwable e2) {
        Errors error = Errors.forException(e2);
        ListTransactionsResponseData response = new ListTransactionsResponseData().setErrorCode(error.code()).setThrottleTimeMs(throttleTimeMs);
        return new ListTransactionsResponse(response);
    }

    public static ListTransactionsRequest parse(ByteBuffer buffer, short version) {
        return new ListTransactionsRequest(new ListTransactionsRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    @Override
    public String toString(boolean verbose) {
        return this.data.toString();
    }

    public static class Builder
    extends AbstractRequest.Builder<ListTransactionsRequest> {
        public final ListTransactionsRequestData data;

        public Builder(ListTransactionsRequestData data) {
            super(ApiKeys.LIST_TRANSACTIONS);
            this.data = data;
        }

        @Override
        public ListTransactionsRequest build(short version) {
            return new ListTransactionsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

