/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.ProduceResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ProduceResponse
extends AbstractResponse {
    public static final long INVALID_OFFSET = -1L;
    private final ProduceResponseData data;

    public ProduceResponse(ProduceResponseData produceResponseData) {
        super(ApiKeys.PRODUCE);
        this.data = produceResponseData;
    }

    @Deprecated
    public ProduceResponse(Map<TopicPartition, PartitionResponse> responses) {
        this(responses, 0);
    }

    @Deprecated
    public ProduceResponse(Map<TopicPartition, PartitionResponse> responses, int throttleTimeMs) {
        this(ProduceResponse.toData(responses, throttleTimeMs));
    }

    private static ProduceResponseData toData(Map<TopicPartition, PartitionResponse> responses, int throttleTimeMs) {
        ProduceResponseData data = new ProduceResponseData().setThrottleTimeMs(throttleTimeMs);
        responses.forEach((tp, response) -> {
            ProduceResponseData.TopicProduceResponse tpr = data.responses().find(tp.topic());
            if (tpr == null) {
                tpr = new ProduceResponseData.TopicProduceResponse().setName(tp.topic());
                data.responses().add(tpr);
            }
            tpr.partitionResponses().add(new ProduceResponseData.PartitionProduceResponse().setIndex(tp.partition()).setBaseOffset(response.baseOffset).setLogStartOffset(response.logStartOffset).setLogAppendTimeMs(response.logAppendTime).setErrorMessage(response.errorMessage).setErrorCode(response.error.code()).setRecordErrors(response.recordErrors.stream().map(e2 -> new ProduceResponseData.BatchIndexAndErrorMessage().setBatchIndex(e2.batchIndex).setBatchIndexErrorMessage(e2.message)).collect(Collectors.toList())));
        });
        return data;
    }

    @Override
    public ProduceResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        this.data.responses().forEach(t2 -> t2.partitionResponses().forEach(p2 -> this.updateErrorCounts(errorCounts, Errors.forCode(p2.errorCode()))));
        return errorCounts;
    }

    public static ProduceResponse parse(ByteBuffer buffer, short version) {
        return new ProduceResponse(new ProduceResponseData(new ByteBufferAccessor(buffer), version));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 6;
    }

    public static final class RecordError {
        public final int batchIndex;
        public final String message;

        public RecordError(int batchIndex, String message) {
            this.batchIndex = batchIndex;
            this.message = message;
        }

        public RecordError(int batchIndex) {
            this.batchIndex = batchIndex;
            this.message = null;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            RecordError that = (RecordError)o2;
            return this.batchIndex == that.batchIndex && Objects.equals(this.message, that.message);
        }

        public int hashCode() {
            return Objects.hash(this.batchIndex, this.message);
        }

        public String toString() {
            return "RecordError(batchIndex=" + this.batchIndex + ", message=" + (this.message == null ? "null" : "'" + this.message + "'") + ")";
        }
    }

    public static final class PartitionResponse {
        public Errors error;
        public long baseOffset;
        public long logAppendTime;
        public long logStartOffset;
        public List<RecordError> recordErrors;
        public String errorMessage;

        public PartitionResponse(Errors error) {
            this(error, -1L, -1L, -1L);
        }

        public PartitionResponse(Errors error, String errorMessage) {
            this(error, -1L, -1L, -1L, Collections.emptyList(), errorMessage);
        }

        public PartitionResponse(Errors error, long baseOffset, long logAppendTime, long logStartOffset) {
            this(error, baseOffset, logAppendTime, logStartOffset, Collections.emptyList(), null);
        }

        public PartitionResponse(Errors error, long baseOffset, long logAppendTime, long logStartOffset, List<RecordError> recordErrors) {
            this(error, baseOffset, logAppendTime, logStartOffset, recordErrors, null);
        }

        public PartitionResponse(Errors error, long baseOffset, long logAppendTime, long logStartOffset, List<RecordError> recordErrors, String errorMessage) {
            this.error = error;
            this.baseOffset = baseOffset;
            this.logAppendTime = logAppendTime;
            this.logStartOffset = logStartOffset;
            this.recordErrors = recordErrors;
            this.errorMessage = errorMessage;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            PartitionResponse that = (PartitionResponse)o2;
            return this.baseOffset == that.baseOffset && this.logAppendTime == that.logAppendTime && this.logStartOffset == that.logStartOffset && this.error == that.error && Objects.equals(this.recordErrors, that.recordErrors) && Objects.equals(this.errorMessage, that.errorMessage);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.error, this.baseOffset, this.logAppendTime, this.logStartOffset, this.recordErrors, this.errorMessage});
        }

        public String toString() {
            StringBuilder b2 = new StringBuilder();
            b2.append('{');
            b2.append("error: ");
            b2.append((Object)this.error);
            b2.append(",offset: ");
            b2.append(this.baseOffset);
            b2.append(",logAppendTime: ");
            b2.append(this.logAppendTime);
            b2.append(", logStartOffset: ");
            b2.append(this.logStartOffset);
            b2.append(", recordErrors: ");
            b2.append(this.recordErrors);
            b2.append(", errorMessage: ");
            if (this.errorMessage != null) {
                b2.append(this.errorMessage);
            } else {
                b2.append("null");
            }
            b2.append('}');
            return b2.toString();
        }
    }
}

