/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.InvalidRequestException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.RequestHeaderData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequestResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.ResponseHeader;
import java.nio.ByteBuffer;

public class RequestHeader
implements AbstractRequestResponse {
    private final RequestHeaderData data;
    private final short headerVersion;

    public RequestHeader(ApiKeys requestApiKey, short requestVersion, String clientId, int correlationId) {
        this(new RequestHeaderData().setRequestApiKey(requestApiKey.id).setRequestApiVersion(requestVersion).setClientId(clientId).setCorrelationId(correlationId), requestApiKey.requestHeaderVersion(requestVersion));
    }

    public RequestHeader(RequestHeaderData data, short headerVersion) {
        this.data = data;
        this.headerVersion = headerVersion;
    }

    public ApiKeys apiKey() {
        return ApiKeys.forId(this.data.requestApiKey());
    }

    public short apiVersion() {
        return this.data.requestApiVersion();
    }

    public short headerVersion() {
        return this.headerVersion;
    }

    public String clientId() {
        return this.data.clientId();
    }

    public int correlationId() {
        return this.data.correlationId();
    }

    @Override
    public RequestHeaderData data() {
        return this.data;
    }

    public void write(ByteBuffer buffer, ObjectSerializationCache serializationCache) {
        this.data.write(new ByteBufferAccessor(buffer), serializationCache, this.headerVersion);
    }

    public int size(ObjectSerializationCache serializationCache) {
        return this.data.size(serializationCache, this.headerVersion);
    }

    public ResponseHeader toResponseHeader() {
        return new ResponseHeader(this.data.correlationId(), this.apiKey().responseHeaderVersion(this.apiVersion()));
    }

    public static RequestHeader parse(ByteBuffer buffer) {
        int apiKey = -1;
        try {
            int position = buffer.position();
            apiKey = buffer.getShort();
            short apiVersion = buffer.getShort();
            short headerVersion = ApiKeys.forId(apiKey).requestHeaderVersion(apiVersion);
            buffer.position(position);
            RequestHeaderData headerData = new RequestHeaderData(new ByteBufferAccessor(buffer), headerVersion);
            if (headerData.clientId() == null) {
                headerData.setClientId("");
            }
            return new RequestHeader(headerData, headerVersion);
        }
        catch (UnsupportedVersionException e2) {
            throw new InvalidRequestException("Unknown API key " + apiKey, e2);
        }
        catch (Throwable ex) {
            throw new InvalidRequestException("Error parsing request header. Our best guess of the apiKey is: " + apiKey, ex);
        }
    }

    public String toString() {
        return "RequestHeader(apiKey=" + (Object)((Object)this.apiKey()) + ", apiVersion=" + this.apiVersion() + ", clientId=" + this.clientId() + ", correlationId=" + this.correlationId() + ")";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        RequestHeader that = (RequestHeader)o2;
        return this.data.equals(that.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }
}

