/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.authenticator;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.KafkaException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.SerializationException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.DefaultPrincipalData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.MessageUtil;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.auth.AuthenticationContext;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.auth.KafkaPrincipal;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.auth.PlaintextAuthenticationContext;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.auth.SslAuthenticationContext;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.kerberos.KerberosName;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.kerberos.KerberosShortNamer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.ssl.SslPrincipalMapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.Principal;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import javax.security.sasl.SaslServer;

public class DefaultKafkaPrincipalBuilder
implements KafkaPrincipalBuilder,
KafkaPrincipalSerde {
    private final KerberosShortNamer kerberosShortNamer;
    private final SslPrincipalMapper sslPrincipalMapper;

    public DefaultKafkaPrincipalBuilder(KerberosShortNamer kerberosShortNamer, SslPrincipalMapper sslPrincipalMapper) {
        this.kerberosShortNamer = kerberosShortNamer;
        this.sslPrincipalMapper = sslPrincipalMapper;
    }

    @Override
    public KafkaPrincipal build(AuthenticationContext context) {
        if (context instanceof PlaintextAuthenticationContext) {
            return KafkaPrincipal.ANONYMOUS;
        }
        if (context instanceof SslAuthenticationContext) {
            SSLSession sslSession = ((SslAuthenticationContext)context).session();
            try {
                return this.applySslPrincipalMapper(sslSession.getPeerPrincipal());
            }
            catch (SSLPeerUnverifiedException se) {
                return KafkaPrincipal.ANONYMOUS;
            }
        }
        if (context instanceof SaslAuthenticationContext) {
            SaslServer saslServer = ((SaslAuthenticationContext)context).server();
            if ("GSSAPI".equals(saslServer.getMechanismName())) {
                return this.applyKerberosShortNamer(saslServer.getAuthorizationID());
            }
            return new KafkaPrincipal("User", saslServer.getAuthorizationID());
        }
        throw new IllegalArgumentException("Unhandled authentication context type: " + context.getClass().getName());
    }

    private KafkaPrincipal applyKerberosShortNamer(String authorizationId) {
        KerberosName kerberosName = KerberosName.parse(authorizationId);
        try {
            String shortName = this.kerberosShortNamer.shortName(kerberosName);
            return new KafkaPrincipal("User", shortName);
        }
        catch (IOException e2) {
            throw new KafkaException("Failed to set name for '" + kerberosName + "' based on Kerberos authentication rules.", e2);
        }
    }

    private KafkaPrincipal applySslPrincipalMapper(Principal principal) {
        try {
            if (!(principal instanceof X500Principal) || principal == KafkaPrincipal.ANONYMOUS) {
                return new KafkaPrincipal("User", principal.getName());
            }
            return new KafkaPrincipal("User", this.sslPrincipalMapper.getName(principal.getName()));
        }
        catch (IOException e2) {
            throw new KafkaException("Failed to map name for '" + principal.getName() + "' based on SSL principal mapping rules.", e2);
        }
    }

    @Override
    public byte[] serialize(KafkaPrincipal principal) {
        DefaultPrincipalData data = new DefaultPrincipalData().setType(principal.getPrincipalType()).setName(principal.getName()).setTokenAuthenticated(principal.tokenAuthenticated());
        return MessageUtil.toVersionPrefixedBytes((short)0, data);
    }

    @Override
    public KafkaPrincipal deserialize(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        short version = buffer.getShort();
        if (version < 0 || version > 0) {
            throw new SerializationException("Invalid principal data version " + version);
        }
        DefaultPrincipalData data = new DefaultPrincipalData(new ByteBufferAccessor(buffer), version);
        return new KafkaPrincipal(data.type(), data.name(), data.tokenAuthenticated());
    }
}

