/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.secured;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.secured.AccessTokenValidator;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.secured.ConfigurationUtils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.secured.LoginAccessTokenValidator;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.secured.ValidatorAccessTokenValidator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jose4j.keys.resolvers.VerificationKeyResolver;

public class AccessTokenValidatorFactory {
    public static AccessTokenValidator create(Map<String, ?> configs) {
        return AccessTokenValidatorFactory.create(configs, (String)null);
    }

    public static AccessTokenValidator create(Map<String, ?> configs, String saslMechanism) {
        ConfigurationUtils cu = new ConfigurationUtils(configs, saslMechanism);
        String scopeClaimName = (String)cu.get("sasl.oauthbearer.scope.claim.name");
        String subClaimName = (String)cu.get("sasl.oauthbearer.sub.claim.name");
        return new LoginAccessTokenValidator(scopeClaimName, subClaimName);
    }

    public static AccessTokenValidator create(Map<String, ?> configs, VerificationKeyResolver verificationKeyResolver) {
        return AccessTokenValidatorFactory.create(configs, null, verificationKeyResolver);
    }

    public static AccessTokenValidator create(Map<String, ?> configs, String saslMechanism, VerificationKeyResolver verificationKeyResolver) {
        ConfigurationUtils cu = new ConfigurationUtils(configs, saslMechanism);
        Set<String> expectedAudiences = null;
        List l2 = (List)cu.get("sasl.oauthbearer.expected.audience");
        if (l2 != null) {
            expectedAudiences = Collections.unmodifiableSet(new HashSet(l2));
        }
        Integer clockSkew = cu.validateInteger("sasl.oauthbearer.clock.skew.seconds", false);
        String expectedIssuer = cu.validateString("sasl.oauthbearer.expected.issuer", false);
        String scopeClaimName = cu.validateString("sasl.oauthbearer.scope.claim.name");
        String subClaimName = cu.validateString("sasl.oauthbearer.sub.claim.name");
        return new ValidatorAccessTokenValidator(clockSkew, expectedAudiences, expectedIssuer, verificationKeyResolver, scopeClaimName, subClaimName);
    }
}

